/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.control;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.model.BSClock;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BSClockControls
extends PiccoloClockControlPanel {
    private BSClock _clock;
    private JSlider _clockIndexSlider;

    public BSClockControls(BSClock bSClock) {
        super(bSClock);
        this._clock = bSClock;
        this._clock.setDt(BSConstants.DEFAULT_CLOCK_STEP);
        this.setRewindButtonVisible(true);
        this.setRewindButtonTooltip(BSResources.getString("button.restart"));
        this.setTimeDisplayVisible(true);
        this.setUnits(BSResources.getString("units.time"));
        this.setTimeFormat(BSConstants.DEFAULT_CLOCK_FORMAT);
        this.setTimeColumns(6);
        this.setTimeFont(BSConstants.TIME_DISPLAY_FONT);
        this.setUnitsFont(BSConstants.TIME_UNITS_FONT);
        this._clockIndexSlider = new JSlider();
        this._clockIndexSlider.setMinimum(0);
        this._clockIndexSlider.setMaximum(BSConstants.CLOCK_STEPS.length - 1);
        this._clockIndexSlider.setMajorTickSpacing(1);
        this._clockIndexSlider.setPaintTicks(true);
        this._clockIndexSlider.setPaintLabels(true);
        this._clockIndexSlider.setSnapToTicks(true);
        this._clockIndexSlider.setValue(0);
        String string = BSResources.getString("label.clockSpeed.normal");
        String string2 = BSResources.getString("label.clockSpeed.fast");
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(this._clockIndexSlider.getMinimum()), new JLabel(string));
        hashtable.put(new Integer(this._clockIndexSlider.getMaximum()), new JLabel(string2));
        this._clockIndexSlider.setLabelTable(hashtable);
        Dimension dimension = this._clockIndexSlider.getPreferredSize();
        Dimension dimension2 = new Dimension(150, (int)dimension.getHeight());
        this._clockIndexSlider.setPreferredSize(dimension2);
        this.setLayout(new FlowLayout(1));
        this.addBetweenTimeDisplayAndButtons(this._clockIndexSlider);
        this._clockIndexSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BSClockControls.this.handleClockIndexChange();
            }
        });
    }

    public JComponent getClockIndexComponent() {
        return this._clockIndexSlider;
    }

    public int getClockIndex() {
        return this._clockIndexSlider.getValue();
    }

    public void setClockIndex(int n) {
        this._clockIndexSlider.setValue(n);
        this.handleClockIndexChange();
    }

    private void handleClockIndexChange() {
        int n = this._clockIndexSlider.getValue();
        this.setTimeFormat(BSConstants.CLOCK_FORMATS[n]);
        this._clock.setDt(BSConstants.CLOCK_STEPS[n]);
        this._clock.resetSimulationTime();
    }
}

