/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.mediabuttons;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.ButtonIconSet;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.IconButton;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.util.ArrayList;

public class PlayPauseButton
extends IconButton {
    private boolean playing;
    private ButtonIconSet buttonIconSet;
    private ArrayList listeners = new ArrayList();
    private ShadowPText pauseLabel;

    public PlayPauseButton(int n) {
        super(n);
        this.buttonIconSet = new ButtonIconSet(n, n);
        this.pauseLabel = new ShadowPText("Paused");
        this.pauseLabel.setTextPaint(Color.RED);
        this.pauseLabel.setFont(new PhetFont(PhetFont.getDefaultFontSize(), true));
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        this.addInputEventListener(buttonEventHandler);
        buttonEventHandler.addButtonEventListener(new ButtonEventHandler.ButtonEventAdapter(){

            public void fire() {
                PlayPauseButton.this.setPlaying(!PlayPauseButton.this.isPlaying());
                PlayPauseButton.this.update();
                PlayPauseButton.this.notifyListeners();
            }
        });
        this.setPlaying(true);
    }

    public void setPlaying(boolean bl) {
        this.playing = bl;
        this.update();
        this.updateImage();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    private void update() {
        super.setIconPath(this.isPlaying() ? this.buttonIconSet.createPauseIconShape() : this.buttonIconSet.createPlayIconShape());
        PDimension pDimension = this.getButtonDimension();
        this.pauseLabel.setScale(1.0);
        this.pauseLabel.setScale(pDimension.width / this.pauseLabel.getFullBounds().width);
        this.pauseLabel.setOffset(pDimension.width / 2.0 - this.pauseLabel.getFullBounds().width / 2.0, 0.0);
        this.pauseLabel.setVisible(!this.isPlaying());
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).playbackStateChanged();
        }
    }

    public static interface Listener {
        public void playbackStateChanged();
    }
}

