/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.event;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Paint;

public abstract class HighlightHandler
extends PBasicInputEventHandler {
    private boolean isMousePressed;
    private boolean isMouseInside;

    protected abstract void setHighlighted(boolean var1);

    public void mouseEntered(PInputEvent pInputEvent) {
        this.isMouseInside = true;
        this.setHighlighted(true);
    }

    public void mouseExited(PInputEvent pInputEvent) {
        this.isMouseInside = false;
        if (!this.isMousePressed) {
            this.setHighlighted(false);
        }
    }

    public void mousePressed(PInputEvent pInputEvent) {
        this.isMousePressed = true;
        this.setHighlighted(true);
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        this.isMousePressed = false;
        if (!this.isMouseInside) {
            this.setHighlighted(false);
        }
    }

    public static class PaintHighlightHandler
    extends HighlightHandler {
        private final PNode node;
        private Paint normal;
        private Paint highlight;

        public PaintHighlightHandler(PNode pNode, Paint paint, Paint paint2) {
            this.node = pNode;
            this.normal = paint;
            this.highlight = paint2;
        }

        protected void setHighlighted(boolean bl) {
            this.node.setPaint(bl ? this.highlight : this.normal);
        }

        public void setNormal(Paint paint) {
            this.normal = paint;
        }

        public void setHighlight(Paint paint) {
            this.highlight = paint;
        }
    }
}

