/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.model.BSSuperpositionCoefficients;
import edu.colorado.phet.boundstates.view.BSPositionAxis;
import edu.colorado.phet.boundstates.view.BSRendererFactory;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class BSEnergyPlot
extends XYPlot
implements Observer {
    private BSModel _model;
    private XYSeries _potentialSeries;
    private XYSeries _normalEigenstatesSeries;
    private XYSeries _selectedEigenstatesSeries;
    private XYSeries _hilitedEigenstateSeries;
    private int _potentialIndex;
    private int _normalEigenstateIndex;
    private int _selectedEigenstateIndex;
    private int _hilitedEigenstateIndex;
    private double _dx;

    public BSEnergyPlot() {
        String string = BSResources.getString("axis.energy") + " (" + BSResources.getString("units.energy") + ")";
        String string2 = BSResources.getString("legend.potentialEnergy");
        int n = 0;
        this._potentialSeries = new XYSeries((Comparable)((Object)string2), false);
        this._potentialIndex = n++;
        Cloneable cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._potentialSeries);
        this.setDataset(this._potentialIndex, (XYDataset)((Object)cloneable));
        Object object = BSRendererFactory.createCurveRenderer();
        object.setPaint(BSConstants.COLOR_SCHEME.getPotentialEnergyColor());
        object.setStroke(BSConstants.POTENTIAL_ENERGY_STROKE);
        this.setRenderer(this._potentialIndex, (XYItemRenderer)object);
        this._hilitedEigenstateSeries = new XYSeries((Comparable)((Object)"hilited eigenstates"), false);
        this._hilitedEigenstateIndex = n++;
        cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._hilitedEigenstateSeries);
        this.setDataset(this._hilitedEigenstateIndex, (XYDataset)((Object)cloneable));
        object = BSRendererFactory.createEigenstatesRenderer();
        object.setPaint(BSConstants.COLOR_SCHEME.getEigenstateHiliteColor());
        object.setStroke(BSConstants.EIGENSTATE_HILITE_STROKE);
        this.setRenderer(this._hilitedEigenstateIndex, (XYItemRenderer)object);
        this._selectedEigenstatesSeries = new XYSeries((Comparable)((Object)"selected eigenstates"), false);
        this._selectedEigenstateIndex = n++;
        cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._selectedEigenstatesSeries);
        this.setDataset(this._selectedEigenstateIndex, (XYDataset)((Object)cloneable));
        object = BSRendererFactory.createEigenstatesRenderer();
        object.setPaint(BSConstants.COLOR_SCHEME.getEigenstateSelectionColor());
        object.setStroke(BSConstants.EIGENSTATE_SELECTION_STROKE);
        this.setRenderer(this._selectedEigenstateIndex, (XYItemRenderer)object);
        this._normalEigenstatesSeries = new XYSeries((Comparable)((Object)"normal eigenstates"), false);
        this._normalEigenstateIndex = n++;
        cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._normalEigenstatesSeries);
        this.setDataset(this._normalEigenstateIndex, (XYDataset)((Object)cloneable));
        object = BSRendererFactory.createEigenstatesRenderer();
        object.setPaint(BSConstants.COLOR_SCHEME.getEigenstateNormalColor());
        object.setStroke(BSConstants.EIGENSTATE_NORMAL_STROKE);
        this.setRenderer(this._normalEigenstateIndex, (XYItemRenderer)object);
        cloneable = new BSPositionAxis();
        object = new NumberAxis(string);
        ((ValueAxis)object).setRange(1.0, 10.0);
        ((Axis)object).setLabelFont(BSConstants.AXIS_LABEL_FONT);
        ((Axis)object).setTickLabelFont(BSConstants.AXIS_TICK_LABEL_FONT);
        ((Axis)object).setTickLabelPaint(BSConstants.COLOR_SCHEME.getTickColor());
        ((Axis)object).setTickMarkPaint(BSConstants.COLOR_SCHEME.getTickColor());
        ((ValueAxis)object).setAutoTickUnitSelection(true);
        ((Axis)object).setLabelInsets(new RectangleInsets(0.0, 0.0, 10.0, 0.0));
        this.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.setBackgroundPaint(BSConstants.COLOR_SCHEME.getChartColor());
        this.setDomainGridlinesVisible(true);
        this.setRangeGridlinesVisible(false);
        this.setDomainGridlinePaint(BSConstants.COLOR_SCHEME.getGridlineColor());
        this.setRangeGridlinePaint(BSConstants.COLOR_SCHEME.getGridlineColor());
        this.setDomainAxis((ValueAxis)cloneable);
        this.setRangeAxis((ValueAxis)object);
        this._dx = 0.1;
    }

    public void setModel(BSModel bSModel) {
        if (this._model != bSModel) {
            if (this._model != null) {
                this._model.deleteObserver(this);
            }
            this._model = bSModel;
            this._model.addObserver(this);
            this.updateAllSeries();
        }
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this.setBackgroundPaint(bSColorScheme.getChartColor());
        this.getDomainAxis().setTickLabelPaint(bSColorScheme.getTickColor());
        this.getDomainAxis().setTickMarkPaint(bSColorScheme.getTickColor());
        this.getRangeAxis().setTickLabelPaint(bSColorScheme.getTickColor());
        this.getRangeAxis().setTickMarkPaint(bSColorScheme.getTickColor());
        this.setDomainGridlinePaint(bSColorScheme.getGridlineColor());
        this.setRangeGridlinePaint(bSColorScheme.getGridlineColor());
        this.getRenderer(this._potentialIndex).setPaint(bSColorScheme.getPotentialEnergyColor());
        this.getRenderer(this._hilitedEigenstateIndex).setPaint(bSColorScheme.getEigenstateHiliteColor());
        this.getRenderer(this._selectedEigenstateIndex).setPaint(bSColorScheme.getEigenstateSelectionColor());
        this.getRenderer(this._normalEigenstateIndex).setPaint(bSColorScheme.getEigenstateNormalColor());
    }

    public void setDx(double d) {
        if (d != this._dx) {
            this._dx = d;
            this.updateAllSeries();
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._model) {
            if (object == "potential") {
                this.updateAllSeries();
            } else if (object == "hilitedEnergy") {
                this.updateHilitedEigenstateSeries();
            } else if (object != "particle") {
                if (object == "superpositionCoefficientsValues") {
                    this.updateSelectedEigenstatesSeries();
                } else if (object != "superpositionCoefficientsCount" && object == null) {
                    this.updateAllSeries();
                }
            }
        }
    }

    private void updateAllSeries() {
        this.updatePotentialSeries();
        this.updateNormalEigenstatesSeries();
        this.updateSelectedEigenstatesSeries();
        this.updateHilitedEigenstateSeries();
    }

    private void updatePotentialSeries() {
        this._potentialSeries.setNotify(false);
        this._potentialSeries.clear();
        double d = this.getDomainAxis().getLowerBound();
        double d2 = this.getDomainAxis().getUpperBound();
        BSAbstractPotential bSAbstractPotential = this._model.getPotential();
        Point2D[] point2DArray = bSAbstractPotential.getPotentialPoints(d, d2, this._dx);
        for (int i = 0; i < point2DArray.length; ++i) {
            double d3 = point2DArray[i].getX();
            double d4 = point2DArray[i].getY();
            if (d4 > 2000.0) {
                d4 = 2000.0;
            } else if (d4 < -2000.0) {
                d4 = -2000.0;
            }
            this._potentialSeries.add(d3, d4);
        }
        this._potentialSeries.setNotify(true);
    }

    private void updateNormalEigenstatesSeries() {
        this._normalEigenstatesSeries.setNotify(false);
        this._normalEigenstatesSeries.clear();
        BSEigenstate[] bSEigenstateArray = this._model.getEigenstates();
        for (int i = 0; i < bSEigenstateArray.length; ++i) {
            this._normalEigenstatesSeries.add(0.0, bSEigenstateArray[i].getEnergy());
        }
        this._normalEigenstatesSeries.setNotify(true);
    }

    private void updateSelectedEigenstatesSeries() {
        this._selectedEigenstatesSeries.setNotify(false);
        this._selectedEigenstatesSeries.clear();
        BSEigenstate[] bSEigenstateArray = this._model.getEigenstates();
        BSSuperpositionCoefficients bSSuperpositionCoefficients = this._model.getSuperpositionCoefficients();
        for (int i = 0; i < bSEigenstateArray.length; ++i) {
            if (bSSuperpositionCoefficients.getCoefficient(i) == 0.0) continue;
            this._selectedEigenstatesSeries.add(0.0, bSEigenstateArray[i].getEnergy());
        }
        this._selectedEigenstatesSeries.setNotify(true);
    }

    private void updateHilitedEigenstateSeries() {
        this._hilitedEigenstateSeries.setNotify(false);
        this._hilitedEigenstateSeries.clear();
        int n = this._model.getHilitedEigenstateIndex();
        if (n != -1) {
            BSEigenstate bSEigenstate = this._model.getEigenstate(n);
            this._hilitedEigenstateSeries.add(0.0, bSEigenstate.getEnergy());
        }
        this._hilitedEigenstateSeries.setNotify(true);
    }
}

