/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.view.LegendItem;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class BSEnergyLegend
extends PNode {
    private static final Stroke BORDER_STROKE = new BasicStroke(0.5f);
    private static final Color BORDER_COLOR = Color.BLACK;
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private LegendItem _totalEnergyItem;
    private LegendItem _potentialEnergyItem;

    public BSEnergyLegend() {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this._totalEnergyItem = new LegendItem(BSResources.getString("legend.totalEnergy"), BSConstants.COLOR_SCHEME.getEigenstateNormalColor());
        this._totalEnergyItem.translate(0.0, 0.0);
        this.addChild(this._totalEnergyItem);
        this._potentialEnergyItem = new LegendItem(BSResources.getString("legend.potentialEnergy"), BSConstants.COLOR_SCHEME.getPotentialEnergyColor());
        this._potentialEnergyItem.translate(this._totalEnergyItem.getFullBounds().getWidth() + 20.0, 0.0);
        this.addChild(this._potentialEnergyItem);
        PBounds pBounds = this.getFullBounds();
        double d = 5.0;
        double d2 = ((RectangularShape)pBounds).getX();
        double d3 = ((RectangularShape)pBounds).getY();
        double d4 = ((RectangularShape)pBounds).getWidth() + 2.0 * d;
        double d5 = ((RectangularShape)pBounds).getHeight() + 2.0 * d;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d4, d5);
        PPath pPath = new PPath(double_);
        pPath.setStroke(BORDER_STROKE);
        pPath.setStrokePaint(BORDER_COLOR);
        pPath.setPaint(BACKGROUND_COLOR);
        this._totalEnergyItem.translate(5.0, 5.0);
        this._potentialEnergyItem.translate(5.0, 5.0);
        this.addChild(0, pPath);
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this._totalEnergyItem.setLinePaint(bSColorScheme.getEigenstateNormalColor());
        this._potentialEnergyItem.setLinePaint(bSColorScheme.getPotentialEnergyColor());
    }
}

