/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.enums.BSBottomPlotMode;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.view.BSAverageProbabilityDensityPlotter;
import edu.colorado.phet.boundstates.view.BSPositionAxis;
import edu.colorado.phet.boundstates.view.BSRendererFactory;
import edu.colorado.phet.boundstates.view.BSWaveFunctionPlotter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.RectangleInsets;

public class BSBottomPlot
extends XYPlot
implements ClockListener,
Observer {
    private BSModel _model;
    private XYSeries _realSeries;
    private XYSeries _imaginarySeries;
    private XYSeries _magnitudeSeries;
    private XYSeries _phaseSeries;
    private XYSeries _probabilityDensitySeries;
    private XYSeries _hiliteSeries;
    private int _realSeriesIndex;
    private int _imaginarySeriesIndex;
    private int _magnitudeSeriesIndex;
    private int _phaseSeriesIndex;
    private int _probabilityDensitySeriesIndex;
    private int _hiliteSeriesIndex;
    private String _waveFunctionLabel = BSResources.getString("axis.waveFunction");
    private String _probabilityDensityLabel = BSResources.getString("axis.probabilityDensity");
    private String _averageProbabilityDensityLabel = BSResources.getString("axis.averageProbabilityDensity");
    private IPlotter _plotter;

    public BSBottomPlot() {
        int n = 0;
        this._realSeriesIndex = n++;
        this._realSeries = new XYSeries((Comparable)((Object)"real"), false);
        Cloneable cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._realSeries);
        this.setDataset(this._realSeriesIndex, (XYDataset)((Object)cloneable));
        Object object = BSRendererFactory.createCurveRenderer();
        object.setPaint(BSConstants.COLOR_SCHEME.getRealColor());
        object.setStroke(BSConstants.REAL_STROKE);
        this.setRenderer(this._realSeriesIndex, (XYItemRenderer)object);
        this._imaginarySeriesIndex = n++;
        this._imaginarySeries = new XYSeries((Comparable)((Object)"imaginary"), false);
        cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._imaginarySeries);
        this.setDataset(this._imaginarySeriesIndex, (XYDataset)((Object)cloneable));
        object = BSRendererFactory.createCurveRenderer();
        object.setPaint(BSConstants.COLOR_SCHEME.getImaginaryColor());
        object.setStroke(BSConstants.IMAGINARY_STROKE);
        this.setRenderer(this._imaginarySeriesIndex, (XYItemRenderer)object);
        this._magnitudeSeriesIndex = n++;
        this._magnitudeSeries = new XYSeries((Comparable)((Object)"magnitude"), false);
        cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._magnitudeSeries);
        this.setDataset(this._magnitudeSeriesIndex, (XYDataset)((Object)cloneable));
        object = BSRendererFactory.createCurveRenderer();
        object.setPaint(BSConstants.COLOR_SCHEME.getMagnitudeColor());
        object.setStroke(BSConstants.MAGNITUDE_STROKE);
        this.setRenderer(this._magnitudeSeriesIndex, (XYItemRenderer)object);
        this._phaseSeriesIndex = n++;
        this._phaseSeries = new XYSeries((Comparable)((Object)"phase"), false);
        cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._phaseSeries);
        this.setDataset(this._phaseSeriesIndex, (XYDataset)((Object)cloneable));
        object = BSRendererFactory.createPhaseRenderer();
        this.setRenderer(this._phaseSeriesIndex, (XYItemRenderer)object);
        this._probabilityDensitySeriesIndex = n++;
        this._probabilityDensitySeries = new XYSeries((Comparable)((Object)"probability density"), false);
        cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._probabilityDensitySeries);
        this.setDataset(this._probabilityDensitySeriesIndex, (XYDataset)((Object)cloneable));
        object = BSRendererFactory.createCurveRenderer();
        object.setPaint(BSConstants.COLOR_SCHEME.getMagnitudeColor());
        object.setStroke(BSConstants.PROBABILITY_DENSITY_STROKE);
        this.setRenderer(this._probabilityDensitySeriesIndex, (XYItemRenderer)object);
        this._hiliteSeriesIndex = n++;
        this._hiliteSeries = new XYSeries((Comparable)((Object)"hilite"), false);
        cloneable = new XYSeriesCollection();
        cloneable.addSeries(this._hiliteSeries);
        this.setDataset(this._hiliteSeriesIndex, (XYDataset)((Object)cloneable));
        object = BSRendererFactory.createCurveRenderer();
        object.setPaint(BSConstants.COLOR_SCHEME.getEigenstateHiliteColor());
        object.setStroke(BSConstants.HILITE_STROKE);
        this.setRenderer(this._hiliteSeriesIndex, (XYItemRenderer)object);
        cloneable = new BSPositionAxis();
        object = new NumberAxis(this._waveFunctionLabel);
        ((ValueAxis)object).setRange(BSConstants.WAVE_FUNCTION_RANGE);
        ((Axis)object).setLabelFont(BSConstants.AXIS_LABEL_FONT);
        ((Axis)object).setTickLabelFont(BSConstants.AXIS_TICK_LABEL_FONT);
        ((Axis)object).setTickLabelPaint(BSConstants.COLOR_SCHEME.getTickColor());
        ((Axis)object).setTickMarkPaint(BSConstants.COLOR_SCHEME.getTickColor());
        ((Axis)object).setTickMarksVisible(true);
        ((Axis)object).setTickLabelsVisible(false);
        ((Axis)object).setLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 35.0));
        this.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.setBackgroundPaint(BSConstants.COLOR_SCHEME.getChartColor());
        this.setDomainGridlinesVisible(true);
        this.setRangeGridlinesVisible(false);
        this.setDomainGridlinePaint(BSConstants.COLOR_SCHEME.getGridlineColor());
        this.setRangeGridlinePaint(BSConstants.COLOR_SCHEME.getGridlineColor());
        this.setDomainAxis((ValueAxis)cloneable);
        this.setRangeAxis((ValueAxis)object);
        this.setMode(BSBottomPlotMode.PROBABILITY_DENSITY);
    }

    public void setModel(BSModel bSModel) {
        if (this._model != bSModel) {
            if (this._model != null) {
                this._model.deleteObserver(this);
            }
            this._model = bSModel;
            this._model.addObserver(this);
            this._plotter.notifyModelChanged();
        }
    }

    public BSModel getModel() {
        return this._model;
    }

    public void setMode(BSBottomPlotMode bSBottomPlotMode) {
        this.clearAllSeries();
        ValueAxis valueAxis = this.getRangeAxis();
        if (bSBottomPlotMode == BSBottomPlotMode.WAVE_FUNCTION) {
            this._plotter = new BSWaveFunctionPlotter(this);
            this.setRealSeriesVisible(true);
            this.setImaginarySeriesVisible(true);
            this.setMagnitudeSeriesVisible(true);
            this.setPhaseSeriesVisible(true);
            this.setProbabilityDensitySeriesVisible(false);
            valueAxis.setLabel(this._waveFunctionLabel);
            valueAxis.setRange(BSConstants.WAVE_FUNCTION_RANGE);
            TickUnits tickUnits = new TickUnits();
            tickUnits.add(new NumberTickUnit(0.5, BSConstants.WAVE_FUNCTION_TICK_FORMAT));
            valueAxis.setStandardTickUnits(tickUnits);
            valueAxis.setAutoTickUnitSelection(true);
        } else if (bSBottomPlotMode == BSBottomPlotMode.PROBABILITY_DENSITY) {
            this._plotter = new BSWaveFunctionPlotter(this);
            this.setRealSeriesVisible(false);
            this.setImaginarySeriesVisible(false);
            this.setMagnitudeSeriesVisible(false);
            this.setPhaseSeriesVisible(false);
            this.setProbabilityDensitySeriesVisible(true);
            valueAxis.setLabel(this._probabilityDensityLabel);
            valueAxis.setRange(BSConstants.PROBABILITY_DENSITY_RANGE);
            TickUnits tickUnits = new TickUnits();
            tickUnits.add(new NumberTickUnit(0.5, BSConstants.PROBABILITY_DENSITY_TICK_FORMAT));
            valueAxis.setStandardTickUnits(tickUnits);
            valueAxis.setAutoTickUnitSelection(true);
        } else if (bSBottomPlotMode == BSBottomPlotMode.PROBABILITY_DENSITY || bSBottomPlotMode == BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY) {
            this._plotter = new BSAverageProbabilityDensityPlotter(this);
            this.setRealSeriesVisible(false);
            this.setImaginarySeriesVisible(false);
            this.setMagnitudeSeriesVisible(false);
            this.setPhaseSeriesVisible(false);
            this.setProbabilityDensitySeriesVisible(true);
            valueAxis.setLabel(this._averageProbabilityDensityLabel);
            valueAxis.setRange(BSConstants.AVERAGE_PROBABILITY_DENSITY_RANGE);
            TickUnits tickUnits = new TickUnits();
            tickUnits.add(new NumberTickUnit(0.5, BSConstants.AVERAGE_PROBABILITY_DENSITY_TICK_FORMAT));
            valueAxis.setStandardTickUnits(tickUnits);
            valueAxis.setAutoTickUnitSelection(true);
        } else {
            throw new UnsupportedOperationException("unsupported mode: " + bSBottomPlotMode);
        }
        if (this._model != null) {
            this._plotter.notifyModelChanged();
        }
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this.setBackgroundPaint(bSColorScheme.getChartColor());
        this.getDomainAxis().setTickLabelPaint(bSColorScheme.getTickColor());
        this.getDomainAxis().setTickMarkPaint(bSColorScheme.getTickColor());
        this.getRangeAxis().setTickLabelPaint(bSColorScheme.getTickColor());
        this.getRangeAxis().setTickMarkPaint(bSColorScheme.getTickColor());
        this.setDomainGridlinePaint(bSColorScheme.getGridlineColor());
        this.setRangeGridlinePaint(bSColorScheme.getGridlineColor());
        this.getRenderer(this._realSeriesIndex).setPaint(bSColorScheme.getRealColor());
        this.getRenderer(this._imaginarySeriesIndex).setPaint(bSColorScheme.getImaginaryColor());
        this.getRenderer(this._magnitudeSeriesIndex).setPaint(bSColorScheme.getMagnitudeColor());
        this.getRenderer(this._probabilityDensitySeriesIndex).setPaint(bSColorScheme.getMagnitudeColor());
        this.getRenderer(this._hiliteSeriesIndex).setPaint(bSColorScheme.getEigenstateHiliteColor());
    }

    public void clearAllSeries() {
        this._realSeries.clear();
        this._imaginarySeries.clear();
        this._magnitudeSeries.clear();
        this._phaseSeries.clear();
        this._probabilityDensitySeries.clear();
        this._hiliteSeries.clear();
    }

    public XYSeries getRealSeries() {
        return this._realSeries;
    }

    public XYSeries getImaginarySeries() {
        return this._imaginarySeries;
    }

    public XYSeries getMagnitudeSeries() {
        return this._magnitudeSeries;
    }

    public XYSeries getPhaseSeries() {
        return this._phaseSeries;
    }

    public XYSeries getProbabilityDensitySeries() {
        return this._probabilityDensitySeries;
    }

    public XYSeries getHiliteSeries() {
        return this._hiliteSeries;
    }

    private void setSeriesVisible(int n, boolean bl) {
        this.getRenderer(n).setSeriesVisible(new Boolean(bl));
        this._plotter.refreshAllSeries();
    }

    private boolean isSeriesVisible(int n) {
        return this.getRenderer(n).getSeriesVisible();
    }

    public void setRealSeriesVisible(boolean bl) {
        this.setSeriesVisible(this._realSeriesIndex, bl);
    }

    public boolean isRealSeriesVisible() {
        return this.isSeriesVisible(this._realSeriesIndex);
    }

    public void setImaginarySeriesVisible(boolean bl) {
        this.setSeriesVisible(this._imaginarySeriesIndex, bl);
    }

    public boolean isImaginarySeriesVisible() {
        return this.isSeriesVisible(this._imaginarySeriesIndex);
    }

    public void setMagnitudeSeriesVisible(boolean bl) {
        this.setSeriesVisible(this._magnitudeSeriesIndex, bl);
    }

    public boolean isMagnitudeSeriesVisible() {
        return this.isSeriesVisible(this._magnitudeSeriesIndex);
    }

    public void setPhaseSeriesVisible(boolean bl) {
        this.setSeriesVisible(this._phaseSeriesIndex, bl);
    }

    public boolean isPhaseSeriesVisible() {
        return this.isSeriesVisible(this._phaseSeriesIndex);
    }

    public void setProbabilityDensitySeriesVisible(boolean bl) {
        this.setSeriesVisible(this._probabilityDensitySeriesIndex, bl);
    }

    public boolean isProbabilityDensitySeriesVisible() {
        return this.isSeriesVisible(this._probabilityDensitySeriesIndex);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._model) {
            if (object == "hilitedEnergy") {
                this._plotter.notifyHiliteChanged();
            } else if (object != "particle" && object != "superpositionCoefficientsCount" && (object == null || object == "potential" || object == "superpositionCoefficientsValues")) {
                this._plotter.notifyModelChanged();
            }
        }
    }

    public void simulationTimeChanged(ClockEvent clockEvent) {
        double d = clockEvent.getSimulationTime();
        this._plotter.notifyTimeChanged(d);
    }

    public void simulationTimeReset(ClockEvent clockEvent) {
    }

    public void clockTicked(ClockEvent clockEvent) {
    }

    public void clockStarted(ClockEvent clockEvent) {
    }

    public void clockPaused(ClockEvent clockEvent) {
    }

    public static interface IPlotter {
        public void notifyModelChanged();

        public void notifyTimeChanged(double var1);

        public void notifyHiliteChanged();

        public void refreshAllSeries();
    }
}

