/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.test;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.model.clock.TimingStrategy;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.help.AbstractHelpItem;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TestHelpRepaint {
    private static final Color BACKGROUND = new Color(208, 255, 252);

    private static class TestApplication
    extends PiccoloPhetApplication {
        public TestApplication(PhetApplicationConfig phetApplicationConfig) throws InterruptedException {
            super(phetApplicationConfig);
            SwingClock swingClock = new SwingClock(40, new TimingStrategy.Constant(1.0));
            TestModule testModule = new TestModule("One", swingClock);
            this.addModule(testModule);
            TestModule testModule2 = new TestModule("Two", swingClock);
            this.addModule(testModule2);
        }
    }

    private static class TestModule
    extends PiccoloModule {
        private PhetPCanvas _canvas = new PhetPCanvas(new Dimension(1000, 1000));
        private XYSeries _series;
        private JFreeChartNode _chartNode;

        public TestModule(String string, IClock iClock) {
            super(string, iClock, false);
            this.setSimulationPanel(this._canvas);
            this._canvas.setBackground(BACKGROUND);
            this._canvas.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    TestModule.this.updateLayout();
                }
            });
            PNode pNode = new PNode();
            this._canvas.addScreenChild(pNode);
            this._series = new XYSeries((Comparable)((Object)"Random data"));
            Cloneable cloneable = new XYPlot();
            Serializable serializable = new NumberAxis("X");
            serializable.setRange(0.0, 200.0);
            ((XYPlot)cloneable).setDomainAxis((ValueAxis)serializable);
            Serializable serializable2 = new NumberAxis("Y");
            ((ValueAxis)serializable2).setRange(-100.0, 100.0);
            ((XYPlot)cloneable).setRangeAxis((ValueAxis)serializable2);
            Serializable serializable3 = new XYSeriesCollection();
            ((XYSeriesCollection)serializable3).addSeries(this._series);
            ((XYPlot)cloneable).setDataset(0, (XYDataset)((Object)serializable3));
            Cloneable cloneable2 = new StandardXYItemRenderer();
            cloneable2.setPaint(Color.RED);
            cloneable2.setStroke(new BasicStroke(2.0f));
            ((XYPlot)cloneable).setRenderer(0, (XYItemRenderer)((Object)cloneable2));
            Cloneable cloneable3 = new JFreeChart((Plot)cloneable);
            ((JFreeChart)cloneable3).setBackgroundPaint(BACKGROUND);
            this._chartNode = new JFreeChartNode((JFreeChart)cloneable3);
            pNode.addChild(this._chartNode);
            PPath pPath = new PPath();
            pPath.setPaint(Color.BLUE);
            pPath.setPathTo(new Rectangle2D.Double(0.0, 0.0, 150.0, 150.0));
            pPath.addInputEventListener(new PDragEventHandler());
            pPath.addInputEventListener(new CursorHandler());
            pPath.setOffset(300.0, 200.0);
            pNode.addChild(pPath);
            cloneable = new PPath();
            ((PNode)cloneable).setPaint(Color.GREEN);
            ((PPath)cloneable).setPathTo(new Rectangle2D.Double(0.0, 0.0, 150.0, 150.0));
            ((PNode)cloneable).addInputEventListener(new PDragEventHandler());
            ((PNode)cloneable).addInputEventListener(new CursorHandler());
            ((PNode)cloneable).setOffset(100.0, 200.0);
            pNode.addChild((PNode)cloneable);
            serializable = new JCheckBox(string);
            serializable2 = new ControlPanel();
            this.setControlPanel((JComponent)serializable2);
            serializable3 = new JPanel();
            ((Container)serializable3).setLayout(new BoxLayout((Container)serializable3, 0));
            ((Container)serializable3).add(Box.createHorizontalStrut(150));
            ((ControlPanel)serializable2).addControlFullWidth((Component)serializable3);
            ((ControlPanel)serializable2).addControl((Component)serializable);
            serializable2 = this.getDefaultHelpPane();
            serializable3 = new HelpBalloon((JComponent)serializable2, "Clock controls", HelpBalloon.BOTTOM_LEFT, 80.0);
            ((HelpPane)serializable2).add((AbstractHelpItem)serializable3);
            ((AbstractHelpItem)serializable3).pointAt(this.getClockControlPanel());
            cloneable2 = new HelpBalloon((JComponent)serializable2, "Drag me", HelpBalloon.LEFT_CENTER, 30.0);
            ((HelpPane)serializable2).add((AbstractHelpItem)cloneable2);
            ((AbstractHelpItem)cloneable2).pointAt(pPath, this._canvas);
            cloneable3 = new HelpBalloon((JComponent)serializable2, "Drag me", HelpBalloon.RIGHT_CENTER, 30.0);
            ((HelpPane)serializable2).add((AbstractHelpItem)cloneable3);
            ((AbstractHelpItem)cloneable3).pointAt((PNode)cloneable, this._canvas);
            HelpBalloon helpBalloon = new HelpBalloon((JComponent)serializable2, "Check me", HelpBalloon.RIGHT_CENTER, 30.0);
            ((HelpPane)serializable2).add(helpBalloon);
            helpBalloon.pointAt((JComponent)serializable);
            this.getClock().addClockListener(new ClockAdapter(){

                public void clockTicked(ClockEvent clockEvent) {
                    double d = clockEvent.getSimulationTime();
                    TestModule.this.updateData(d);
                }
            });
            this.updateLayout();
            this.updateData(0.0);
        }

        public boolean hasHelp() {
            return true;
        }

        public void setHelpEnabled(boolean bl) {
            super.setHelpEnabled(bl);
            PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
            this.paintImmediately(phetFrame);
        }

        private void paintImmediately(Component component) {
            Container container;
            if (component instanceof JComponent) {
                container = (JComponent)component;
                ((JComponent)container).paintImmediately(container.getBounds());
            }
            if (component instanceof Container) {
                container = (Container)component;
                int n = container.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component2 = container.getComponent(i);
                    this.paintImmediately(component2);
                }
            }
        }

        private void updateLayout() {
            double d = 10.0;
            double d2 = 10.0;
            double d3 = (double)this._canvas.getWidth() - 20.0;
            double d4 = (double)this._canvas.getHeight() - 20.0 - d2;
            this._chartNode.setBounds(0.0, 0.0, d3, d4);
            this._chartNode.setOffset(d, d2);
        }

        private void updateData(double d) {
            this._series.setNotify(false);
            this._series.clear();
            for (double d2 = 0.0; d2 <= 201.0; d2 += 1.0) {
                double d3 = 100.0 * Math.sin(3.0 * d2 - d);
                this._series.add(d2, d3);
            }
            this._series.setNotify(true);
        }
    }
}

