/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.module;

import edu.colorado.phet.boundstates.control.ZoomControl;
import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.util.AxisSpec;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import java.text.DecimalFormat;
import org.jfree.data.Range;

public class BSTwoWellsSpec
extends BSAbstractModuleSpec {
    private static final BSWellType[] WELL_TYPES = new BSWellType[]{BSWellType.SQUARE, BSWellType.COULOMB_1D};
    private static final BSWellType DEFAULT_WELL_TYPE = BSWellType.SQUARE;
    private static final DoubleRange MASS_MULTIPLIER_RANGE = new DoubleRange(0.5, 1.1, 1.0, 2);
    private static final IntegerRange NUMBER_OF_WELLS_RANGE = new IntegerRange(1, 2, 2);
    private static final DoubleRange FIELD_CONSTANT_RANGE = new DoubleRange(-1.0, 1.0, 0.0, 1);
    private static final Range COULOMB_1D_ENERGY_RANGE1 = new Range(-20.5, 0.5);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT1 = new DecimalFormat("#0");
    private static final Range COULOMB_1D_ENERGY_RANGE2 = new Range(-30.5, 0.5);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT2 = new DecimalFormat("#0");
    private static final Range COULOMB_1D_ENERGY_RANGE3 = new Range(-51.0, 1.0);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT3 = new DecimalFormat("#0");
    private static final Range COULOMB_1D_ENERGY_RANGE4 = new Range(-101.0, 1.0);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT4 = new DecimalFormat("##0");
    private static final Range COULOMB_1D_ENERGY_RANGE5 = new Range(-155.0, 5.0);
    private static final DecimalFormat COULOMB_1D_ENERGY_TICK_FORMAT5 = new DecimalFormat("##0");
    private static final DoubleRange COULOMB_1D_OFFSET_RANGE = new DoubleRange(-5.0, 15.0, 0.0, 1);
    private static final DoubleRange COULOMB_1D_SPACING_RANGE = new DoubleRange(0.05, 0.7, 0.7, 2);
    private static final Range SQUARE_ENERGY_RANGE = new Range(-0.5, 20.5);
    private static final DecimalFormat SQUARE_ENERGY_TICK_FORMAT = new DecimalFormat("0");
    private static final DoubleRange SQUARE_OFFSET_RANGE = new DoubleRange(-5.0, 15.0, 0.0, 1);
    private static final DoubleRange SQUARE_WIDTH_RANGE = new DoubleRange(0.1, 3.0, 1.0, 1);
    private static final DoubleRange SQUARE_HEIGHT_RANGE = new DoubleRange(0.0, 20.0, 10.0, 1);
    private static final DoubleRange SQUARE_SEPARATION_RANGE = new DoubleRange(0.05, 0.7, 0.1, 2);

    public BSTwoWellsSpec() {
        this.setId("twoWellsModule");
        this.setWellTypes(WELL_TYPES);
        this.setDefaultWellType(DEFAULT_WELL_TYPE);
        this.setNumberOfWellsSupported(false);
        this.setOffsetControlSupported(false);
        this.setSuperpositionControlsSupported(true);
        this.setParticleControlsSupported(false);
        this.setMagnifyingGlassSupported(true);
        this.setMagnifyingGlassSelected(false);
        this.setAverageProbabilityDensityIsSupported(false);
        this.setFieldConstantSupported(false);
        this.setMassMultiplierRange(MASS_MULTIPLIER_RANGE);
        this.setNumberOfWellsRange(NUMBER_OF_WELLS_RANGE);
        this.setFieldConstantRange(FIELD_CONSTANT_RANGE);
        this.setMagnification(10.0);
        AxisSpec axisSpec = new AxisSpec(COULOMB_1D_ENERGY_RANGE1, 5.0, COULOMB_1D_ENERGY_TICK_FORMAT1);
        Object object = new AxisSpec(COULOMB_1D_ENERGY_RANGE2, 5.0, COULOMB_1D_ENERGY_TICK_FORMAT2);
        Object object2 = new AxisSpec(COULOMB_1D_ENERGY_RANGE3, 10.0, COULOMB_1D_ENERGY_TICK_FORMAT3);
        AxisSpec axisSpec2 = new AxisSpec(COULOMB_1D_ENERGY_RANGE4, 20.0, COULOMB_1D_ENERGY_TICK_FORMAT4);
        AxisSpec axisSpec3 = new AxisSpec(COULOMB_1D_ENERGY_RANGE5, 50.0, COULOMB_1D_ENERGY_TICK_FORMAT5);
        AxisSpec[] axisSpecArray = new AxisSpec[]{axisSpec, object, object2, axisSpec2, axisSpec3};
        ZoomControl.ZoomSpec zoomSpec = new ZoomControl.ZoomSpec(axisSpecArray);
        BSPotentialSpec.Coulomb1D coulomb1D = new BSPotentialSpec.Coulomb1D(zoomSpec, COULOMB_1D_OFFSET_RANGE, COULOMB_1D_SPACING_RANGE);
        this.setCoulomb1DSpec(coulomb1D);
        axisSpec = new AxisSpec(SQUARE_ENERGY_RANGE, 5.0, SQUARE_ENERGY_TICK_FORMAT);
        object = new ZoomControl.ZoomSpec(axisSpec);
        object2 = new BSPotentialSpec.Square((ZoomControl.ZoomSpec)object, SQUARE_OFFSET_RANGE, SQUARE_WIDTH_RANGE, SQUARE_HEIGHT_RANGE, SQUARE_SEPARATION_RANGE);
        this.setSquareSpec((BSPotentialSpec)object2);
    }
}

