/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.model.BSAbstractPotential;

public class SchmidtLeeSolver {
    private double _hb;
    private double _minX;
    private double _maxX;
    private int _numberOfPoints;
    private double[] _potentialValues;

    public SchmidtLeeSolver(double d, double d2, double d3, int n, BSAbstractPotential bSAbstractPotential) {
        this._hb = d;
        this._minX = d2;
        this._maxX = d3;
        this._numberOfPoints = n;
        this._potentialValues = this.calculatePotential(bSAbstractPotential);
    }

    public double getEnergy(int n) throws SchmidtLeeException {
        return this.calculateEnergy(n);
    }

    public double[] getWaveFunction(double d) {
        return this.calculateWaveFunction(d);
    }

    private double[] calculatePotential(BSAbstractPotential bSAbstractPotential) {
        double[] dArray = new double[this._numberOfPoints];
        double d = (this._maxX - this._minX) / (double)(this._numberOfPoints - 1);
        for (int i = 1; i < this._numberOfPoints - 1; ++i) {
            double d2 = this._minX + (double)i * d;
            dArray[i] = bSAbstractPotential.getEnergyAt(d2);
        }
        return dArray;
    }

    private double calculateEnergy(int n) throws SchmidtLeeException {
        int n2;
        Tester tester = null;
        Tester tester2 = null;
        Tester tester3 = null;
        double d = 0.0;
        double d2 = this._hb * (double)(n + 1) * (double)(n + 1) * 10.0 / ((this._maxX - this._minX) * (this._maxX - this._minX));
        for (n2 = 0; n2 < 100 && !(tester2 = this.integrate(d2 *= 2.0)).isupper(n); ++n2) {
        }
        if (n2 == 100) {
            throw new SchmidtLeeException("upper bound not found, nodes=" + n);
        }
        double d3 = -this._hb * (double)(n + 1) * (double)(n + 1) * 10.0 / ((this._maxX - this._minX) * (this._maxX - this._minX));
        for (n2 = 0; n2 < 100 && (tester3 = this.integrate(d3 *= 2.0)).isupper(n); ++n2) {
        }
        if (n2 == 100) {
            throw new SchmidtLeeException("lower bound not found, nodes=" + n);
        }
        for (n2 = 0; n2 < 100 && tester3.node != tester2.node; ++n2) {
            d = 0.5 * (d2 + d3);
            tester = this.integrate(d);
            if (tester.isupper(n)) {
                d2 = d;
                tester2 = tester;
                continue;
            }
            d3 = d;
            tester3 = tester;
        }
        if (n2 == 100) {
            this.warn("No convergence in binary chop, nodes=" + n);
            return d;
        }
        for (n2 = 0; n2 < 100 && Math.abs(tester2.alogd - tester3.alogd) > 1.0E-10; ++n2) {
            d = d2 - (d2 - d3) * tester2.alogd / (tester3.alogd - tester2.alogd);
            if (d > d2 || d < d3) {
                d = 0.5 * (d2 + d3);
            }
            if ((tester = this.integrate(d)).isupper(n)) {
                d2 = d;
                tester2 = tester;
                continue;
            }
            d3 = d;
            tester3 = tester;
        }
        if (n2 == 100) {
            this.warn("No convergence in interpolation, nodes=" + n);
            return d;
        }
        return d;
    }

    private Tester integrate(double d) {
        double d2;
        int n;
        double d3 = 1.0 / this._hb;
        int n2 = (int)((double)this._numberOfPoints * 0.53);
        double d4 = (this._maxX - this._minX) / (double)(this._numberOfPoints - 1);
        double d5 = d4 * d4 / 12.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d4;
        double d9 = 0.0;
        double d10 = d4;
        int n3 = 0;
        double d11 = 0.0;
        double d12 = d3 * (this._potentialValues[1] - d);
        for (n = 2; n <= n2 + 1; ++n) {
            d6 = d7;
            d7 = d8;
            d2 = d11;
            d11 = d12;
            d12 = d3 * (this._potentialValues[n] - d);
            d8 = (d7 * (2.0 + 10.0 * d5 * d11) - d6 * (1.0 - d5 * d2)) / (1.0 - d5 * d12);
            if (n > n2 || !(d8 < 0.0 && d7 > 0.0) && (!(d8 > 0.0) || !(d7 < 0.0))) continue;
            ++n3;
        }
        double d13 = (d8 - d6) / (2.0 * d4 * d7);
        d7 = d9;
        d8 = d10;
        d11 = 0.0;
        d12 = d3 * (this._potentialValues[this._numberOfPoints - 2] - d);
        for (n = this._numberOfPoints - 3; n >= n2 - 1; --n) {
            d6 = d7;
            d7 = d8;
            d2 = d11;
            d11 = d12;
            d12 = d3 * (this._potentialValues[n] - d);
            d8 = (d7 * (2.0 + 10.0 * d5 * d11) - d6 * (1.0 - d5 * d2)) / (1.0 - d5 * d12);
            if (n < n2 || !(d8 < 0.0 && d7 > 0.0) && (!(d8 > 0.0) || !(d7 < 0.0))) continue;
            ++n3;
        }
        return new Tester(n3, d13 += (d8 - d6) / (2.0 * d4 * d7));
    }

    private double[] calculateWaveFunction(double d) {
        double d2;
        int n;
        double[] dArray = new double[this._numberOfPoints];
        double d3 = 1.0 / this._hb;
        int n2 = (int)((double)this._numberOfPoints * 0.53);
        double d4 = (this._maxX - this._minX) / (double)(this._numberOfPoints - 1);
        double d5 = d4 * d4 / 12.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = d4;
        double d9 = 0.0;
        double d10 = d4;
        dArray[0] = d7;
        dArray[1] = d8;
        dArray[this._numberOfPoints - 1] = d9;
        dArray[this._numberOfPoints - 2] = d10;
        double d11 = 0.0;
        double d12 = d3 * (this._potentialValues[1] - d);
        for (n = 2; n <= n2; ++n) {
            d6 = d7;
            d7 = d8;
            d2 = d11;
            d11 = d12;
            d12 = d3 * (this._potentialValues[n] - d);
            dArray[n] = d8 = (d7 * (2.0 + 10.0 * d5 * d11) - d6 * (1.0 - d5 * d2)) / (1.0 - d5 * d12);
        }
        double d13 = d8;
        d7 = d9;
        d8 = d10;
        d11 = 0.0;
        d12 = d3 * (this._potentialValues[this._numberOfPoints - 2] - d);
        for (n = this._numberOfPoints - 3; n >= n2; --n) {
            d6 = d7;
            d7 = d8;
            d2 = d11;
            d11 = d12;
            d12 = d3 * (this._potentialValues[n] - d);
            dArray[n] = d8 = (d7 * (2.0 + 10.0 * d5 * d11) - d6 * (1.0 - d5 * d2)) / (1.0 - d5 * d12);
        }
        d13 /= d8;
        n = this._numberOfPoints - 2;
        while (n >= n2) {
            int n3 = n--;
            dArray[n3] = dArray[n3] * d13;
        }
        d13 = 0.0;
        for (n = 0; n < this._numberOfPoints; ++n) {
            double d14 = Math.abs(dArray[n]);
            d13 = d13 > d14 ? d13 : d14;
        }
        d13 = 1.0 / d13;
        n = 0;
        while (n < this._numberOfPoints) {
            int n4 = n++;
            dArray[n4] = dArray[n4] * d13;
        }
        return dArray;
    }

    private void warn(String string) {
    }

    public static class SchmidtLeeException
    extends Exception {
        public SchmidtLeeException(String string) {
            super(string);
        }
    }

    private static class Tester {
        public int node;
        public double alogd;

        public Tester(int n, double d) {
            this.node = n;
            this.alogd = d;
        }

        public boolean isupper(int n) {
            return this.node > n || this.node == n && this.alogd < 0.0;
        }
    }
}

