/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.model.BSSuperpositionCoefficients;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class BSWaveFunctionCache {
    private ArrayList _items = new ArrayList();
    private double _minPosition = 0.0;
    private double _maxPosition = 0.0;
    private double _sumScalingCoefficient;

    public double getMinPosition() {
        return this._minPosition;
    }

    public double getMaxPosition() {
        return this._maxPosition;
    }

    public double getSumScalingCoefficient() {
        return this._sumScalingCoefficient;
    }

    public int getSize() {
        return this._items.size();
    }

    public Item getItem(int n) {
        return (Item)this._items.get(n);
    }

    public int getNumberOfPointsInEachWaveFunction() {
        int n = 0;
        if (this._items.size() > 0) {
            n = this.getItem(0).getPoints().length;
        }
        return n;
    }

    public void update(BSModel bSModel, double d, double d2) {
        this._items.clear();
        this._minPosition = d;
        this._maxPosition = d2;
        BSAbstractPotential bSAbstractPotential = bSModel.getPotential();
        BSEigenstate[] bSEigenstateArray = bSModel.getEigenstates();
        BSSuperpositionCoefficients bSSuperpositionCoefficients = bSModel.getSuperpositionCoefficients();
        boolean bl = bSSuperpositionCoefficients.isSuperpositionState();
        int n = bSSuperpositionCoefficients.getNumberOfCoefficients();
        double[] dArray = null;
        for (int i = 0; i < n; ++i) {
            double d3 = bSSuperpositionCoefficients.getCoefficient(i);
            if (d3 == 0.0) continue;
            Point2D[] point2DArray = bSAbstractPotential.getWaveFunctionPoints(bSEigenstateArray[i], d, d2);
            double d4 = 1.0;
            if (bl) {
                d4 = bSAbstractPotential.getNormalizationCoefficient(point2DArray, i);
            }
            Item item = new Item(i, d4, point2DArray);
            this._items.add(item);
            if (!bl) continue;
            if (dArray == null) {
                dArray = new double[point2DArray.length];
            }
            for (int j = 0; j < point2DArray.length; ++j) {
                int n2 = j;
                dArray[n2] = dArray[n2] + d4 * d3 * point2DArray[j].getY();
            }
        }
        if (!bl) {
            this._sumScalingCoefficient = 1.0;
        } else {
            double d5 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                double d6 = Math.abs((double)dArray[i]);
                if (!(d6 > d5)) continue;
                d5 = d6;
            }
            this._sumScalingCoefficient = 1.0 / d5;
        }
    }

    public static class Item {
        private int _eigenstateIndex;
        private double _normalizationCoefficient;
        private Point2D[] _points;

        public Item(int n, double d, Point2D[] point2DArray) {
            this._eigenstateIndex = n;
            this._normalizationCoefficient = d;
            this._points = point2DArray;
        }

        public int getEigenstateIndex() {
            return this._eigenstateIndex;
        }

        public double getNormalizationCoefficient() {
            return this._normalizationCoefficient;
        }

        public Point2D[] getPoints() {
            return this._points;
        }
    }
}

