/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSObservable;
import edu.colorado.phet.boundstates.model.BSParticle;
import edu.colorado.phet.boundstates.model.BSSuperpositionCoefficients;
import java.util.Observable;
import java.util.Observer;

public class BSModel
extends BSObservable
implements Observer {
    private BSParticle _particle;
    private BSAbstractPotential _potential;
    private BSSuperpositionCoefficients _superpositionCoefficients;
    private BSEigenstate[] _eigenstates;
    private int _hilitedEigenstateIndex;

    public BSModel(BSParticle bSParticle, BSAbstractPotential bSAbstractPotential, BSSuperpositionCoefficients bSSuperpositionCoefficients) {
        this._particle = bSParticle;
        this._particle.addObserver(this);
        this._potential = bSAbstractPotential;
        this._potential.addObserver(this);
        this._superpositionCoefficients = bSSuperpositionCoefficients;
        this._superpositionCoefficients.addObserver(this);
        this.syncWithPotential();
    }

    public void setParticle(BSParticle bSParticle) {
        if (bSParticle != this._particle) {
            if (this._particle != null) {
                this._particle.deleteObserver(this);
            }
            this._particle = bSParticle;
            this._particle.addObserver(this);
            this.notifyObservers("particle");
        }
    }

    public void setPotential(BSAbstractPotential bSAbstractPotential) {
        if (bSAbstractPotential != this._potential) {
            if (this._potential != null) {
                this._potential.deleteObserver(this);
            }
            this._potential = bSAbstractPotential;
            this._potential.addObserver(this);
            this.syncWithPotential();
            this.notifyObservers("potential");
        }
    }

    public BSAbstractPotential getPotential() {
        return this._potential;
    }

    public BSSuperpositionCoefficients getSuperpositionCoefficients() {
        return this._superpositionCoefficients;
    }

    public BSEigenstate[] getEigenstates() {
        return this._eigenstates;
    }

    public void setHilitedEigenstateIndex(int n) {
        if (n != this._hilitedEigenstateIndex) {
            this._hilitedEigenstateIndex = n;
            this.notifyObservers("hilitedEnergy");
        }
    }

    public int getHilitedEigenstateIndex() {
        return this._hilitedEigenstateIndex;
    }

    public int getClosestEigenstateIndex(double d, double d2) {
        int n;
        block3: {
            block4: {
                n = -1;
                if (this._eigenstates == null || this._eigenstates.length <= 0) break block3;
                if (this._eigenstates.length != 1) break block4;
                if (!(Math.abs(this._eigenstates[0].getEnergy() - d) <= d2)) break block3;
                n = 0;
                break block3;
            }
            for (int i = 1; i < this._eigenstates.length; ++i) {
                double d3;
                double d4 = this._eigenstates[i].getEnergy();
                if (d == d4) {
                    n = i;
                    break;
                }
                if (!(d < d4)) continue;
                double d5 = this._eigenstates[i - 1].getEnergy();
                double d6 = Math.abs(d4 - d);
                if (d6 <= (d3 = Math.abs(d - d5)) && d6 <= d2) {
                    n = i;
                    break;
                }
                if (!(d6 > d3) || !(d3 <= d2)) continue;
                n = i - 1;
                break;
            }
        }
        return n;
    }

    private void syncWithPotential() {
        this._hilitedEigenstateIndex = -1;
        this._eigenstates = this._potential.getEigenstates();
        this._superpositionCoefficients.setNumberOfCoefficients(this._eigenstates.length);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._particle) {
            this.notifyObservers("particle");
        } else if (observable == this._potential) {
            this.syncWithPotential();
            this.notifyObservers("potential");
        } else if (observable == this._superpositionCoefficients) {
            this.notifyObservers(object);
        }
    }

    public BSWellType getWellType() {
        return this._potential.getWellType();
    }

    public int getNumberOfWells() {
        return this._potential.getNumberOfWells();
    }

    public BSEigenstate getEigenstate(int n) {
        if (n < 0 || n >= this._eigenstates.length) {
            throw new IndexOutOfBoundsException("index out of bounds: " + n);
        }
        return this._eigenstates[n];
    }
}

