/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSParticle;
import java.util.ArrayList;

public class BSHarmonicOscillatorPotential
extends BSAbstractPotential {
    private double _angularFrequency;

    public BSHarmonicOscillatorPotential(BSParticle bSParticle, double d, double d2) {
        super(bSParticle, 1, d);
        this.setAngularFrequency(d2);
    }

    public double getAngularFrequency() {
        return this._angularFrequency;
    }

    public void setAngularFrequency(double d) {
        if (d != this._angularFrequency) {
            this._angularFrequency = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public BSWellType getWellType() {
        return BSWellType.HARMONIC_OSCILLATOR;
    }

    public boolean supportsMultipleWells() {
        return false;
    }

    public int getGroundStateSubscript() {
        return 0;
    }

    public double getEnergyAt(double d) {
        assert (this.getNumberOfWells() == 1);
        double d2 = this.getOffset();
        double d3 = this.getCenter();
        double d4 = this.getParticle().getMass();
        double d5 = this.getAngularFrequency();
        return d2 + 0.5 * d4 * d5 * d5 * (d - d3) * (d - d3);
    }

    protected BSEigenstate[] calculateEigenstates() {
        assert (this.getNumberOfWells() == 1);
        return this.calculateEigenstatesAnalytic();
    }

    private BSEigenstate[] calculateEigenstatesAnalytic() {
        ArrayList<BSEigenstate> arrayList = new ArrayList<BSEigenstate>();
        boolean bl = false;
        int n = 0;
        double d = this.getOffset() + 20.0;
        while (!bl) {
            double d2 = 0.658 * this._angularFrequency * ((double)n + 0.5) + this.getOffset();
            if (d2 <= d) {
                int n2 = n;
                arrayList.add(new BSEigenstate(n2, d2));
            } else {
                bl = true;
            }
            ++n;
        }
        return arrayList.toArray(new BSEigenstate[arrayList.size()]);
    }
}

