/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSCoulomb1DPotential;
import edu.colorado.phet.boundstates.model.BSCoulomb3DSolver;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSParticle;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class BSCoulomb3DPotential
extends BSCoulomb1DPotential {
    public BSCoulomb3DPotential(BSParticle bSParticle, double d) {
        super(bSParticle, 1, d, 0.0);
    }

    public BSWellType getWellType() {
        return BSWellType.COULOMB_3D;
    }

    public boolean supportsMultipleWells() {
        return false;
    }

    public Point2D[] getWaveFunctionPoints(BSEigenstate bSEigenstate, double d, double d2) {
        if (this.getNumberOfWells() != 1) {
            return super.getWaveFunctionPoints(bSEigenstate, d, d2);
        }
        BSCoulomb3DSolver bSCoulomb3DSolver = new BSCoulomb3DSolver(this, this.getParticle());
        return bSCoulomb3DSolver.getWaveFunction(bSEigenstate.getSubscript(), d, d2, 1350);
    }

    public double getNormalizationCoefficient(Point2D[] point2DArray, int n) {
        double d = this.getParticle().getMass();
        int n2 = n + 1;
        return 1.0 / BSCoulomb3DSolver.getScalingCoefficient(n2, d);
    }

    protected BSEigenstate[] calculateEigenstates() {
        if (this.getNumberOfWells() != 1) {
            throw new UnsupportedOperationException("multiple wells are not supported");
        }
        BSCoulomb3DSolver bSCoulomb3DSolver = new BSCoulomb3DSolver(this, this.getParticle());
        ArrayList<BSEigenstate> arrayList = new ArrayList<BSEigenstate>();
        int n = this.getGroundStateSubscript();
        for (int i = 1; i <= 10; ++i) {
            double d = bSCoulomb3DSolver.getEnergy(i);
            arrayList.add(new BSEigenstate(n, d));
            ++n;
        }
        return arrayList.toArray(new BSEigenstate[arrayList.size()]);
    }
}

