/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSObservable;
import edu.colorado.phet.boundstates.model.BSParticle;
import edu.colorado.phet.boundstates.model.SchmidtLeeSolver;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;

public abstract class BSAbstractPotential
extends BSObservable
implements Observer {
    private int _numberOfWells;
    private double _center;
    private double _offset;
    private BSParticle _particle;
    private BSEigenstate[] _eigenstates;
    private double _fieldConstant = 0.0;

    public BSAbstractPotential(BSParticle bSParticle, int n, double d) {
        this.setNumberOfWells(n);
        this.setOffset(d);
        this.setCenter(0.0);
        this.setParticle(bSParticle);
    }

    public BSParticle getParticle() {
        return this._particle;
    }

    public void setParticle(BSParticle bSParticle) {
        if (bSParticle != this._particle) {
            if (this._particle != null) {
                this._particle.deleteObserver(this);
            }
            this._particle = bSParticle;
            this._particle.addObserver(this);
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public int getNumberOfWells() {
        return this._numberOfWells;
    }

    public void setNumberOfWells(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("invalid numberOfWells:" + n);
        }
        if (n != 1 && !this.supportsMultipleWells()) {
            throw new UnsupportedOperationException("multiple wells are not supported");
        }
        if (n != this._numberOfWells) {
            this._numberOfWells = n;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public double getCenter() {
        return this._center;
    }

    private void setCenter(double d) {
        if (d != this._center) {
            this._center = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public double getOffset() {
        return this._offset;
    }

    public void setOffset(double d) {
        if (d != this._offset) {
            this._offset = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public void setFieldConstant(double d) {
        if (d != this._fieldConstant) {
            this._fieldConstant = d;
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public double getFieldConstant() {
        return this._fieldConstant;
    }

    public Point2D[] getPotentialPoints(double d, double d2, double d3) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (double d4 = d; d4 <= d2; d4 += d3) {
            Point2D.Double double_ = new Point2D.Double(d4, this.getEnergyAt(d4));
            arrayList.add(double_);
        }
        return arrayList.toArray(new Point2D.Double[arrayList.size()]);
    }

    public BSEigenstate[] getEigenstates() {
        if (this._eigenstates == null) {
            this._eigenstates = this.calculateEigenstates();
            assert (this._eigenstates != null);
        }
        return this._eigenstates;
    }

    protected void markEigenstatesDirty() {
        this._eigenstates = null;
    }

    public Point2D[] getWaveFunctionPoints(BSEigenstate bSEigenstate, double d, double d2) {
        double d3 = bSEigenstate.getEnergy();
        double d4 = 0.432964 / (2.0 * this.getParticle().getMass());
        SchmidtLeeSolver schmidtLeeSolver = new SchmidtLeeSolver(d4, d, d2, 1350, this);
        double[] dArray = schmidtLeeSolver.getWaveFunction(d3);
        double d5 = (d2 - d) / 1350.0;
        Point2D[] point2DArray = new Point2D.Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            double d6 = d + (double)i * d5;
            double d7 = dArray[i];
            point2DArray[i] = new Point2D.Double(d6, d7);
        }
        return point2DArray;
    }

    public double getNormalizationCoefficient(Point2D[] point2DArray, int n) {
        double d = point2DArray[1].getX() - point2DArray[0].getX();
        double d2 = 0.0;
        for (int i = 0; i < point2DArray.length; ++i) {
            double d3 = point2DArray[i].getY();
            d2 += d3 * d3;
        }
        return 1.0 / Math.sqrt(d2 * d);
    }

    protected SchmidtLeeSolver getEigenstateSolver() {
        double d = 0.432964 / (2.0 * this.getParticle().getMass());
        double d2 = BSConstants.POSITION_MODEL_RANGE.getLowerBound();
        double d3 = BSConstants.POSITION_MODEL_RANGE.getUpperBound();
        return new SchmidtLeeSolver(d, d2, d3, 1350, this);
    }

    protected double getEnergyCutOff() {
        double d = this.getFieldConstant();
        double d2 = 0.0;
        d2 = d > 0.0 ? this.getEnergyAt(BSConstants.POSITION_MODEL_RANGE.getLowerBound()) : this.getEnergyAt(BSConstants.POSITION_MODEL_RANGE.getUpperBound());
        return d2;
    }

    public void update(Observable observable, Object object) {
        if (observable == this._particle) {
            this.markEigenstatesDirty();
            this.notifyObservers();
        }
    }

    public abstract BSWellType getWellType();

    public abstract boolean supportsMultipleWells();

    public abstract int getGroundStateSubscript();

    public abstract double getEnergyAt(double var1);

    protected abstract BSEigenstate[] calculateEigenstates();
}

