/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.model;

import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSParticle;
import java.awt.geom.Point2D;

public abstract class BSAbstractCoulombSolver {
    private static final double SQRT_4_PI = Math.sqrt(Math.PI * 4);
    private final double _offset;
    private final double _mass;
    private final int _l;
    private final double _a;

    protected BSAbstractCoulombSolver(BSAbstractPotential bSAbstractPotential, BSParticle bSParticle) {
        if (bSAbstractPotential.getNumberOfWells() != 1) {
            throw new UnsupportedOperationException("solver supports only 1 well case");
        }
        this._offset = bSAbstractPotential.getOffset();
        this._mass = bSParticle.getMass();
        this._l = 0;
        this._a = BSAbstractCoulombSolver.get_a(bSParticle.getMass());
    }

    protected double getMass() {
        return this._mass;
    }

    protected static double get_a(double d) {
        return 0.432964 / (d * 1.44);
    }

    public double getEnergy(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        return this._offset + -(this._mass * 1.44 * 1.44) / (0.865928 * (double)n * (double)n);
    }

    public Point2D[] getWaveFunction(int n, double d, double d2, int n2) {
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        Point2D[] point2DArray = new Point2D.Double[n2];
        double d3 = (d2 - d) / (double)n2;
        double d4 = d;
        double d5 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d5 = this.psiScaled(n, d4);
            point2DArray[i] = new Point2D.Double(d4, d5);
            d4 += d3;
        }
        return point2DArray;
    }

    protected abstract double psiScaled(int var1, double var2);

    protected double psi(int n, double d) {
        assert (n >= 1);
        double d2 = Math.abs(d);
        return 1.0 / SQRT_4_PI * Math.pow(d2, this._l) * Math.exp(-d2 / ((double)n * this._a)) * this.bxSum(n, d);
    }

    private double bxSum(int n, double d) {
        assert (n >= 1);
        double d2 = Math.abs(d);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i <= n - this._l - 1; ++i) {
            d4 = this.b(i, n, d5);
            d3 += d4 * Math.pow(d2, i);
            d5 = d4;
        }
        return d3;
    }

    private double b(int n, int n2, double d) {
        assert (n >= 0);
        assert (n2 >= 1);
        double d2 = 0.0;
        d2 = n == 0 ? 2.0 * Math.pow((double)n2 * this._a, -1.5) : 2.0 / ((double)n2 * this._a) * ((double)(n + this._l - n2) / (double)(n * (n + 2 * this._l + 1))) * d;
        return d2;
    }
}

