/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.draghandles.BSPotentialHandle;
import edu.colorado.phet.boundstates.model.BSSquarePotential;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BSSquareHeightHandle
extends BSPotentialHandle {
    public BSSquareHeightHandle(BSSquarePotential bSSquarePotential, BSPotentialSpec bSPotentialSpec, BSCombinedChartNode bSCombinedChartNode) {
        super(bSSquarePotential, bSPotentialSpec, bSCombinedChartNode, 1);
        int n = bSPotentialSpec.getHeightRange().getSignificantDecimalPlaces();
        String string = BSSquareHeightHandle.createNumberFormat(n);
        this.setValueNumberFormat(string);
        this.setValuePattern(BSResources.getString("drag.height"));
        this.updateDragBounds();
    }

    public void updateDragBounds() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        BSCombinedChartNode bSCombinedChartNode = this.getChartNode();
        assert (bSSquarePotential.getCenter() == 0.0);
        double d = BSConstants.POSITION_VIEW_RANGE.getLowerBound();
        double d2 = BSConstants.POSITION_VIEW_RANGE.getUpperBound();
        double d3 = bSCombinedChartNode.positionToNode(d);
        double d4 = bSCombinedChartNode.positionToNode(d2);
        int n = bSSquarePotential.getNumberOfWells();
        double d5 = bSSquarePotential.getFieldConstant();
        double d6 = bSSquarePotential.getCenter(n - 1) + bSSquarePotential.getWidth() / 2.0 + 0.1;
        double d7 = bSSquarePotential.getOffset() + bSPotentialSpec.getHeightRange().getMin() + d5 * d6;
        double d8 = bSSquarePotential.getOffset() + bSPotentialSpec.getHeightRange().getMax() + d5 * d6;
        double d9 = bSCombinedChartNode.energyToNode(d8);
        double d10 = bSCombinedChartNode.energyToNode(d7);
        double d11 = d4 - d3;
        double d12 = d10 - d9;
        Rectangle2D rectangle2D = new Rectangle2D.Double(d3, d9, d11, d12);
        rectangle2D = bSCombinedChartNode.localToGlobal(rectangle2D);
        this.setDragBounds(rectangle2D);
        this.updateView();
    }

    protected void updateModel() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        bSSquarePotential.deleteObserver(this);
        Point2D point2D = this.getGlobalPosition();
        Point2D point2D2 = this.viewToModel(point2D);
        double d = point2D2.getY();
        int n = bSSquarePotential.getNumberOfWells();
        double d2 = bSSquarePotential.getFieldConstant();
        double d3 = bSSquarePotential.getCenter(n - 1) + bSSquarePotential.getWidth() / 2.0 + 0.1;
        double d4 = d - bSSquarePotential.getOffset() - d2 * d3;
        int n2 = bSPotentialSpec.getHeightRange().getSignificantDecimalPlaces();
        d4 = BSSquareHeightHandle.round(d4, n2);
        bSSquarePotential.setHeight(d4);
        this.setValueDisplay(d4);
        bSSquarePotential.addObserver(this);
    }

    protected void updateView() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        this.removePropertyChangeListener(this);
        int n = bSSquarePotential.getNumberOfWells();
        double d = bSSquarePotential.getCenter(n - 1);
        double d2 = bSSquarePotential.getWidth();
        double d3 = bSSquarePotential.getHeight();
        double d4 = d + d2 / 2.0 + 0.1;
        double d5 = bSSquarePotential.getEnergyAt(d4);
        Point2D.Double double_ = new Point2D.Double(d4, d5);
        Point2D point2D = this.modelToView(double_);
        this.setGlobalPosition(point2D);
        this.setValueDisplay(d3);
        this.addPropertyChangeListener(this);
    }
}

