/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.draghandles.BSAbstractDragManager;
import edu.colorado.phet.boundstates.draghandles.BSAbstractHandle;
import edu.colorado.phet.boundstates.draghandles.BSAbstractMarker;
import edu.colorado.phet.boundstates.draghandles.BSSquareHeightHandle;
import edu.colorado.phet.boundstates.draghandles.BSSquareOffsetHandle;
import edu.colorado.phet.boundstates.draghandles.BSSquareSeparationHandle;
import edu.colorado.phet.boundstates.draghandles.BSSquareSeparationMarker;
import edu.colorado.phet.boundstates.draghandles.BSSquareWidthHandle;
import edu.colorado.phet.boundstates.model.BSSquarePotential;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import edu.umd.cs.piccolo.PNode;
import java.util.Observable;
import java.util.Observer;

public class BSSquareDragManager
extends BSAbstractDragManager
implements Observer {
    private BSSquarePotential _potential = null;
    private BSAbstractHandle _separationHandle = null;

    public BSSquareDragManager(BSAbstractModuleSpec bSAbstractModuleSpec, BSCombinedChartNode bSCombinedChartNode) {
        super(bSAbstractModuleSpec, bSCombinedChartNode);
    }

    public void setPotential(BSSquarePotential bSSquarePotential) {
        this.removeAllHandlesAndMarkers();
        this._separationHandle = null;
        if (this._potential != null) {
            this._potential.deleteObserver(this);
        }
        this._potential = bSSquarePotential;
        if (this._potential != null) {
            this._potential.addObserver(this);
        }
        if (bSSquarePotential != null) {
            PNode pNode;
            BSAbstractModuleSpec bSAbstractModuleSpec = this.getModuleSpec();
            BSPotentialSpec bSPotentialSpec = bSAbstractModuleSpec.getSquareSpec();
            BSCombinedChartNode bSCombinedChartNode = this.getChartNode();
            if (bSAbstractModuleSpec.isOffsetControlSupported()) {
                pNode = new BSSquareOffsetHandle(bSSquarePotential, bSPotentialSpec, bSCombinedChartNode);
                this.addHandle((BSAbstractHandle)pNode);
            }
            if (!bSPotentialSpec.getHeightRange().isZero()) {
                pNode = new BSSquareHeightHandle(bSSquarePotential, bSPotentialSpec, bSCombinedChartNode);
                this.addHandle((BSAbstractHandle)pNode);
            }
            if (!bSPotentialSpec.getWidthRange().isZero()) {
                pNode = new BSSquareWidthHandle(bSSquarePotential, bSPotentialSpec, bSCombinedChartNode);
                this.addHandle((BSAbstractHandle)pNode);
            }
            if (bSAbstractModuleSpec.getNumberOfWellsRange().getMax() > 1) {
                pNode = new BSSquareSeparationMarker(bSSquarePotential, bSCombinedChartNode);
                this.addMarker((BSAbstractMarker)pNode);
                this._separationHandle = new BSSquareSeparationHandle(bSSquarePotential, bSPotentialSpec, bSCombinedChartNode);
                this.addHandle(this._separationHandle);
                this.updateSeparationHandle();
            }
        }
    }

    public void update(Observable observable, Object object) {
        this.updateSeparationHandle();
    }

    private void updateSeparationHandle() {
        if (this._separationHandle != null && this._potential != null) {
            this._separationHandle.setVisible(this._potential.getNumberOfWells() > 1);
        }
    }
}

