/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.draghandles.BSPotentialHandle;
import edu.colorado.phet.boundstates.model.BSHarmonicOscillatorPotential;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;

public class BSHarmonicOscillatorAngularFrequencyHandle
extends BSPotentialHandle {
    public BSHarmonicOscillatorAngularFrequencyHandle(BSHarmonicOscillatorPotential bSHarmonicOscillatorPotential, BSPotentialSpec bSPotentialSpec, BSCombinedChartNode bSCombinedChartNode) {
        super(bSHarmonicOscillatorPotential, bSPotentialSpec, bSCombinedChartNode, 0);
        int n = bSPotentialSpec.getAngularFrequencyRange().getSignificantDecimalPlaces();
        String string = BSHarmonicOscillatorAngularFrequencyHandle.createNumberFormat(n);
        this.setValueNumberFormat(string);
        this.setValuePattern(BSResources.getString("drag.angularFrequency"));
        this.updateDragBounds();
    }

    public void updateDragBounds() {
        BSHarmonicOscillatorPotential bSHarmonicOscillatorPotential = (BSHarmonicOscillatorPotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        BSCombinedChartNode bSCombinedChartNode = this.getChartNode();
        assert (bSHarmonicOscillatorPotential.getNumberOfWells() == 1);
        assert (bSHarmonicOscillatorPotential.getCenter() == 0.0);
        double d = bSPotentialSpec.getAngularFrequencyRange().getMin();
        double d2 = bSPotentialSpec.getAngularFrequencyRange().getMax();
        double d3 = bSHarmonicOscillatorPotential.getParticle().getMass();
        double d4 = -(BSHarmonicOscillatorAngularFrequencyHandle.angularFrequencyToWidth(d, d3) / 2.0);
        double d5 = -(BSHarmonicOscillatorAngularFrequencyHandle.angularFrequencyToWidth(d2, d3) / 2.0);
        double d6 = bSCombinedChartNode.positionToNode(d4);
        double d7 = bSCombinedChartNode.positionToNode(d5);
        ValueAxis valueAxis = bSCombinedChartNode.getEnergyPlot().getRangeAxis();
        double d8 = valueAxis.getLowerBound();
        double d9 = valueAxis.getUpperBound();
        double d10 = bSCombinedChartNode.energyToNode(d9);
        double d11 = bSCombinedChartNode.energyToNode(d8);
        double d12 = d7 - d6;
        double d13 = d11 - d10;
        Rectangle2D rectangle2D = new Rectangle2D.Double(d6, d10, d12, d13);
        rectangle2D = bSCombinedChartNode.localToGlobal(rectangle2D);
        this.setDragBounds(rectangle2D);
        this.updateView();
    }

    protected void updateModel() {
        BSHarmonicOscillatorPotential bSHarmonicOscillatorPotential = (BSHarmonicOscillatorPotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        bSHarmonicOscillatorPotential.deleteObserver(this);
        Point2D point2D = this.getGlobalPosition();
        Point2D point2D2 = this.viewToModel(point2D);
        double d = point2D2.getX();
        double d2 = 2.0 * Math.abs(d);
        double d3 = bSHarmonicOscillatorPotential.getParticle().getMass();
        double d4 = BSHarmonicOscillatorAngularFrequencyHandle.widthToAngularFrequency(d2, d3);
        int n = bSPotentialSpec.getAngularFrequencyRange().getSignificantDecimalPlaces();
        d4 = BSHarmonicOscillatorAngularFrequencyHandle.round(d4, n);
        bSHarmonicOscillatorPotential.setAngularFrequency(d4);
        this.setValueDisplay(d4);
        bSHarmonicOscillatorPotential.addObserver(this);
    }

    protected void updateView() {
        BSHarmonicOscillatorPotential bSHarmonicOscillatorPotential = (BSHarmonicOscillatorPotential)this.getPotential();
        this.removePropertyChangeListener(this);
        double d = bSHarmonicOscillatorPotential.getAngularFrequency();
        double d2 = bSHarmonicOscillatorPotential.getParticle().getMass();
        double d3 = BSHarmonicOscillatorAngularFrequencyHandle.angularFrequencyToWidth(d, d2);
        double d4 = bSHarmonicOscillatorPotential.getOffset();
        double d5 = -(d3 / 2.0);
        double d6 = d4 + 4.0;
        Point2D.Double double_ = new Point2D.Double(d5, d6);
        Point2D point2D = this.modelToView(double_);
        this.setGlobalPosition(point2D);
        this.setValueDisplay(d);
        this.addPropertyChangeListener(this);
    }

    private static double angularFrequencyToWidth(double d, double d2) {
        double d3 = Math.sqrt(8.0 / (d2 * d * d));
        return 2.0 * d3;
    }

    private static double widthToAngularFrequency(double d, double d2) {
        double d3 = d / 2.0;
        return Math.sqrt(8.0 / (d2 * d3 * d3));
    }
}

