/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.common.piccolophet.event.ConstrainedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;

public abstract class BSAbstractHandle
extends PPath
implements PropertyChangeListener {
    private static final NumberFormat DEFAULT_VALUE_NUMBER_FORMAT = new DecimalFormat("0.0");
    private static final Color DEFAULT_NORMAL_COLOR = Color.WHITE;
    private static final Color DEFAULT_HILITE_COLOR = Color.YELLOW;
    private static final Color DEFAULT_VALUE_COLOR = Color.BLACK;
    private static final Color DEFAULT_STROKE_COLOR = Color.BLACK;
    private int _orientation;
    private Point2D _registrationPoint;
    private ConstrainedDragHandler _dragHandler;
    private HTMLNode _valueNode;
    private NumberFormat _valueNumberFormat;
    private String _valuePattern;
    private Color _normalColor = DEFAULT_NORMAL_COLOR;
    private Color _hiliteColor = DEFAULT_HILITE_COLOR;
    private final HighlightHandler.PaintHighlightHandler _highlightHandler;

    public BSAbstractHandle(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("invalid orientation: " + n);
        }
        this._orientation = n;
        Shape shape = BSAbstractHandle.createShape(n);
        this.setPathTo(shape);
        this.setPaint(DEFAULT_NORMAL_COLOR);
        this.setStroke(BSConstants.DRAG_HANDLE_STROKE);
        this.setStrokePaint(DEFAULT_STROKE_COLOR);
        this._registrationPoint = new Point2D.Double(this.getWidth() / 2.0, this.getHeight() / 2.0);
        this.translate(-this._registrationPoint.getX(), -this._registrationPoint.getY());
        this._valueNumberFormat = DEFAULT_VALUE_NUMBER_FORMAT;
        this._valuePattern = "{0}";
        this._valueNode = new HTMLNode();
        this.addChild(this._valueNode);
        this._valueNode.setVisible(false);
        this._valueNode.setPickable(false);
        this._valueNode.setFont(BSConstants.DRAG_HANDLE_FONT);
        this._valueNode.setHTMLColor(DEFAULT_VALUE_COLOR);
        this._valueNode.setHTML("?");
        PBounds pBounds = this.getBounds();
        double d = ((RectangularShape)pBounds).getX() + ((RectangularShape)pBounds).getWidth();
        double d2 = ((RectangularShape)pBounds).getY() - this._valueNode.getHeight() + 3.0;
        this._valueNode.translate(d, d2);
        this.addInputEventListener(new CursorHandler());
        this._dragHandler = new ConstrainedDragHandler();
        this.addInputEventListener(this._dragHandler);
        this._dragHandler.setTreatAsPointEnabled(true);
        this._dragHandler.setUseFullBounds(false);
        this._dragHandler.setNodeCenter(this._registrationPoint.getX(), this._registrationPoint.getY());
        if (n == 0) {
            this._dragHandler.setVerticalLockEnabled(true);
        } else {
            this._dragHandler.setHorizontalLockEnabled(true);
        }
        this.addInputEventListener(new ShowValueHandler());
        this._highlightHandler = new HighlightHandler.PaintHighlightHandler(this, this._normalColor, this._hiliteColor);
        this.addInputEventListener(this._highlightHandler);
    }

    protected void setValueDisplay(double d) {
        String string = this._valueNumberFormat.format(d);
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(this._valuePattern, objectArray);
        this._valueNode.setHTML(string2);
    }

    public void setValueNumberFormat(String string) {
        this._valueNumberFormat = new DecimalFormat(string);
        this.updateView();
    }

    public void setValuePattern(String string) {
        this._valuePattern = string;
        this.updateView();
    }

    public void setValueColor(Color color) {
        this._valueNode.setHTMLColor(color);
    }

    private void setValueVisible(boolean bl) {
        this._valueNode.setVisible(bl);
    }

    public void setDragBounds(Rectangle2D rectangle2D) {
        this._dragHandler.setDragBounds(rectangle2D);
    }

    public void setGlobalPosition(Point2D point2D) {
        Point2D point2D2 = this.getGlobalPosition();
        double d = point2D.getX() - point2D2.getX();
        double d2 = point2D.getY() - point2D2.getY();
        this.translate(d, d2);
    }

    public Point2D getGlobalPosition() {
        PBounds pBounds = this.getGlobalBounds();
        double d = ((RectangularShape)pBounds).getX() + this._registrationPoint.getX();
        double d2 = ((RectangularShape)pBounds).getY() + this._registrationPoint.getY();
        return new Point2D.Double(d, d2);
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this.setNormalColor(bSColorScheme.getDragHandleColor());
        this.setHiliteColor(bSColorScheme.getDragHandleHiliteColor());
        this.setValueColor(bSColorScheme.getDragHandleValueColor());
    }

    public void setNormalColor(Color color) {
        this._normalColor = color;
        this._highlightHandler.setNormal(color);
        this.setPaint(this._normalColor);
    }

    public void setHiliteColor(Color color) {
        this._hiliteColor = color;
        this._highlightHandler.setHighlight(color);
    }

    protected abstract void updateDragBounds();

    protected abstract void updateModel();

    protected abstract void updateView();

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this && propertyChangeEvent.getPropertyName().equals("transform")) {
            this.updateModel();
        }
    }

    protected static Shape createShape(int n) {
        return BSAbstractHandle.createArrowShape(n, 24.0f);
    }

    private static Shape createArrowShape(int n, float f) {
        Shape shape = null;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(0.25f * f, 0.33f * f);
        generalPath.lineTo(0.08f * f, 0.33f * f);
        generalPath.lineTo(0.08f * f, 0.67f * f);
        generalPath.lineTo(0.25f * f, 0.67f * f);
        generalPath.lineTo(0.0f * f, 1.0f * f);
        generalPath.lineTo(-0.25f * f, 0.67f * f);
        generalPath.lineTo(-0.08f * f, 0.67f * f);
        generalPath.lineTo(-0.08f * f, 0.33f * f);
        generalPath.lineTo(-0.25f * f, 0.33f * f);
        generalPath.closePath();
        if (n == 1) {
            shape = generalPath;
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(90.0));
            shape = affineTransform.createTransformedShape(generalPath);
        }
        return shape;
    }

    protected static String createNumberFormat(int n) {
        String string = "0.";
        for (int i = 0; i < n; ++i) {
            string = string + "0";
        }
        return string;
    }

    private class ShowValueHandler
    extends PBasicInputEventHandler {
        private boolean _mouseIsPressed;
        private boolean _mouseIsInside;

        public void mousePressed(PInputEvent pInputEvent) {
            this._mouseIsPressed = true;
            BSAbstractHandle.this.setValueVisible(true);
        }

        public void mouseReleased(PInputEvent pInputEvent) {
            this._mouseIsPressed = false;
            BSAbstractHandle.this.setValueVisible(this._mouseIsInside);
        }

        public void mouseEntered(PInputEvent pInputEvent) {
            this._mouseIsInside = true;
            BSAbstractHandle.this.setValueVisible(true);
        }

        public void mouseExited(PInputEvent pInputEvent) {
            this._mouseIsInside = false;
            BSAbstractHandle.this.setValueVisible(this._mouseIsPressed);
        }
    }
}

