/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.dialog;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.dialog.BSAbstractConfigureDialog;
import edu.colorado.phet.boundstates.model.BSCoulomb1DPotential;
import edu.colorado.phet.boundstates.model.BSCoulomb3DPotential;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.Container;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BSCoulomb3DDialog
extends BSAbstractConfigureDialog {
    private LinearValueControl _offsetControl;

    public BSCoulomb3DDialog(Frame frame, BSCoulomb3DPotential bSCoulomb3DPotential, BSAbstractModuleSpec bSAbstractModuleSpec) {
        super(frame, BSResources.getString("BSCoulomb3DDialog.title"), bSCoulomb3DPotential);
        JPanel jPanel = this.createInputPanel(bSAbstractModuleSpec);
        this.createUI(jPanel);
        this.updateControls();
    }

    protected JPanel createInputPanel(BSAbstractModuleSpec bSAbstractModuleSpec) {
        BSPotentialSpec bSPotentialSpec = bSAbstractModuleSpec.getCoulomb3DSpec();
        String string = BSResources.getString("units.energy");
        Object object = bSPotentialSpec.getOffsetRange();
        double d = ((DoubleRange)object).getDefault();
        double d2 = ((DoubleRange)object).getMin();
        double d3 = ((DoubleRange)object).getMax();
        String string2 = BSResources.getString("label.wellOffset");
        String string3 = "0.0";
        int n = 4;
        this._offsetControl = new LinearValueControl(d2, d3, string2, string3, string);
        this._offsetControl.setValue(d);
        this._offsetControl.setUpDownArrowDelta(0.1);
        this._offsetControl.setTextFieldColumns(n);
        this._offsetControl.setTextFieldEditable(true);
        this._offsetControl.setNotifyWhileAdjusting(false);
        this._offsetControl.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                BSCoulomb3DDialog.this.handleOffsetChange();
            }
        });
        object = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)object);
        ((Container)object).setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        int n2 = 0;
        int n3 = 0;
        if (this._offsetControl != null) {
            easyGridBagLayout.addComponent(this._offsetControl, n2, n3);
            ++n2;
        }
        return object;
    }

    protected void updateControls() {
        BSCoulomb1DPotential bSCoulomb1DPotential = (BSCoulomb1DPotential)this.getPotential();
        this._offsetControl.setValue(bSCoulomb1DPotential.getOffset());
    }

    private void handleOffsetChange() {
        double d = this._offsetControl.getValue();
        this.setObservePotential(false);
        this.getPotential().setOffset(d);
        this.setObservePotential(true);
        this.adjustClockState(this._offsetControl);
    }
}

