/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.dialog;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractValueControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public abstract class BSAbstractConfigureDialog
extends PaintImmediateDialog
implements Observer {
    protected static final Insets SLIDER_INSETS = new Insets(0, 0, 0, 0);
    private BSAbstractPotential _potential;
    private IClock _clock;
    private boolean _clockWasRunning;
    private boolean _isSliderDragging;

    public BSAbstractConfigureDialog(Frame frame, String string, BSAbstractPotential bSAbstractPotential) {
        super(frame, string);
        this.setModal(false);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BSAbstractConfigureDialog.this.dispose();
            }
        });
        this._potential = bSAbstractPotential;
        this._potential.addObserver(this);
        this._clock = PhetApplication.getInstance().getActiveModule().getClock();
        this._clockWasRunning = false;
        this._isSliderDragging = false;
    }

    protected void createUI(JPanel jPanel) {
        JPanel jPanel2 = this.createActionsPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)new JSeparator(), "North");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(new EmptyBorder(10, 10, 0, 10));
        jPanel4.add((Component)jPanel, "Center");
        jPanel4.add((Component)jPanel3, "South");
        this.getContentPane().add(jPanel4);
        this.pack();
    }

    protected JPanel createActionsPanel() {
        JButton jButton = new JButton(BSResources.getString("button.close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BSAbstractConfigureDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    protected BSAbstractPotential getPotential() {
        return this._potential;
    }

    protected void setObservePotential(boolean bl) {
        if (bl) {
            this._potential.addObserver(this);
        } else {
            this._potential.deleteObserver(this);
        }
    }

    protected void adjustClockState(AbstractValueControl abstractValueControl) {
        if (abstractValueControl.getNotifyWhileAdjusting()) {
            if (!abstractValueControl.isAdjusting()) {
                this._isSliderDragging = false;
                if (this._clockWasRunning) {
                    this._clock.start();
                    this._clockWasRunning = false;
                }
            } else if (!this._isSliderDragging) {
                this._isSliderDragging = true;
                this._clockWasRunning = this._clock.isRunning();
                if (this._clockWasRunning) {
                    this._clock.pause();
                }
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this._potential) {
            this.updateControls();
        }
    }

    protected abstract void updateControls();

    public void dispose() {
        if (this._potential != null) {
            this._potential.deleteObserver(this);
            this._potential = null;
        }
        super.dispose();
    }
}

