/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.quantumwaveinterference.controls.DetectorSheetControlPanel;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityBeamPanel;
import edu.colorado.phet.quantumwaveinterference.phetcommon.IntegralModelElement;
import edu.colorado.phet.quantumwaveinterference.phetcommon.ShinyPanel;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.WavefunctionGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.DetectionRateDebugger;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.HitGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.ImageFade;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;

public class DetectorSheetPNode
extends PhetPNode {
    private QWIPanel QWIPanel;
    private BufferedImage bufferedImage;
    private ScreenGraphic screenGraphic;
    private int opacity = 255;
    private double brightness;
    private IntegralModelElement fadeElement;
    private ColorData rootColor = new ColorData(380.0);
    private ImageFade imageFade;
    private DetectionRateDebugger detectionRateDebugger = new DetectionRateDebugger();
    private WavefunctionGraphic wavefunctionGraphic;
    private int detectorSheetHeight;
    private DetectorSheetControlPanel detectorSheetControlPanel;
    private PSwing detectorSheetControlPanelPNode;
    private MyConnectorGraphic connectorGraphic;
    private final double shearAngle = 0.4636;
    private PText title = new PText();
    private ArrayList listeners = new ArrayList();

    public DetectorSheetPNode(QWIPanel qWIPanel, WavefunctionGraphic wavefunctionGraphic, int n) {
        this.wavefunctionGraphic = wavefunctionGraphic;
        this.detectorSheetHeight = n;
        this.QWIPanel = qWIPanel;
        this.recreateImage();
        this.title.setTextPaint(Color.black);
        this.title.setFont(new PhetFont(1, 14));
        this.screenGraphic = new ScreenGraphic(this.bufferedImage);
        this.setBrightness(0.2);
        this.imageFade = new ImageFade();
        this.fadeElement = new IntegralModelElement(new ModelElement(){

            public void stepInTime(double d) {
                if (DetectorSheetPNode.this.isFadeEnabled() && !this.isContinuousDisplay()) {
                    DetectorSheetPNode.this.imageFade.fade(DetectorSheetPNode.this.getBufferedImage());
                    DetectorSheetPNode.this.screenGraphic.repaint();
                }
            }

            private boolean isContinuousDisplay() {
                return DetectorSheetPNode.this.isContinuousDisplay();
            }
        }, 500);
        this.detectorSheetControlPanel = new DetectorSheetControlPanel(this);
        this.detectorSheetControlPanelPNode = new PSwing(new ShinyPanel(this.detectorSheetControlPanel));
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DetectorSheetPNode.this.recreateImage();
                DetectorSheetPNode.this.screenGraphic.setImage(DetectorSheetPNode.this.bufferedImage);
            }
        };
        wavefunctionGraphic.addPropertyChangeListener("fullBounds", propertyChangeListener);
        wavefunctionGraphic.addPropertyChangeListener("bounds", propertyChangeListener);
        qWIPanel.addListener(new QWIPanel.Adapter(){

            public void fadeStateChanged() {
                DetectorSheetPNode.this.synchronizeFadeState();
            }
        });
        this.synchronizeFadeState();
        this.connectorGraphic = new MyConnectorGraphic();
        this.addChild(this.connectorGraphic);
        this.addChild(this.screenGraphic);
        this.addChild(this.detectorSheetControlPanelPNode);
        this.addChild(this.title);
    }

    public void setFadeDelay(int n) {
        this.fadeElement.setInterval(n);
    }

    private boolean isContinuousDisplay() {
        if (this.QWIPanel instanceof IntensityBeamPanel) {
            IntensityBeamPanel intensityBeamPanel = (IntensityBeamPanel)this.QWIPanel;
            return intensityBeamPanel.isContinuousMode();
        }
        return false;
    }

    protected void layoutChildren() {
        this.screenGraphic.setTransform(new AffineTransform());
        double d = Math.tan(0.4636);
        this.screenGraphic.getTransformReference(true).shear(d, 0.0);
        this.detectorSheetControlPanelPNode.setOffset(this.screenGraphic.getFullBounds().getWidth() + 12.0, this.screenGraphic.getFullBounds().getY());
        this.title.setOffset(0.0, this.screenGraphic.getFullBounds().getY() - this.title.getFullBounds().getHeight());
        this.connectorGraphic.update();
    }

    public void setAlignment(WavefunctionGraphic wavefunctionGraphic) {
        double d = this.screenGraphic.getFullBounds().getHeight() / 2.0 * Math.tan(0.4636);
        this.setOffset(wavefunctionGraphic.getFullBounds().getX() - d, wavefunctionGraphic.getFullBounds().getY() - this.screenGraphic.getFullBounds().getHeight() / 2.0);
    }

    public void synchronizeFadeState() {
        if (this.QWIPanel.isFadeEnabled()) {
            this.getBaseModel().addModelElement(this.fadeElement);
        } else {
            while (this.getBaseModel().containsModelElement(this.fadeElement)) {
                this.getBaseModel().removeModelElement(this.fadeElement);
            }
        }
    }

    private BaseModel getBaseModel() {
        return this.QWIPanel.getSchrodingerModule().getModel();
    }

    public boolean isFadeEnabled() {
        return this.QWIPanel.isFadeEnabled();
    }

    public double getBrightness() {
        return this.brightness;
    }

    public void setBrightness(double d) {
        this.brightness = d;
        this.setOpacity(this.toOpacity(this.brightness));
        this.notifyBrightnessChanged();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyBrightnessChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.brightnessChanged();
        }
    }

    private int toOpacity(double d) {
        return (int)(d * 255.0);
    }

    public BufferedImage copyScreen() {
        int n = this.bufferedImage.getHeight() / 2;
        BufferedImage bufferedImage = new BufferedImage(this.bufferedImage.getWidth(), n, this.bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawRenderedImage(this.bufferedImage, new AffineTransform());
        graphics2D.dispose();
        return bufferedImage;
    }

    public void addDetectionEvent(double d, double d2) {
        if (this.detectionRateDebugger != null) {
            this.detectionRateDebugger.addDetectionEvent();
        }
        this.detectorSheetControlPanel.setClearButtonVisible(true);
        this.setSaveButtonVisible(true);
        Graphics2D graphics2D = this.bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PNode pNode = this.createDetectionGraphic(d, d2, this.opacity);
        pNode.fullPaint(new PPaintContext(graphics2D));
        graphics2D.dispose();
        this.repaint();
    }

    private PNode createDetectionGraphic(double d, double d2, int n) {
        if (this.rootColor != null) {
            return new HitGraphic(d, d2, n, this.rootColor);
        }
        return new HitGraphic(d, d2, n);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void reset() {
        this.recreateImage();
        this.screenGraphic.setImage(this.bufferedImage);
    }

    private void recreateImage() {
        int n = this.wavefunctionGraphic.getWavefunctionGraphicWidth();
        int n2 = this.detectorSheetHeight;
        if (this.bufferedImage != null && this.bufferedImage.getWidth() == n && this.bufferedImage.getHeight() == n2) {
            Graphics2D graphics2D = this.bufferedImage.createGraphics();
            graphics2D.setPaint(Color.black);
            graphics2D.fillRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        } else {
            this.bufferedImage = new BufferedImage(n, n2, 1);
        }
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setOpacity(int n) {
        this.opacity = n;
    }

    public void clearScreen() {
        this.reset();
    }

    public void setSaveButtonVisible(boolean bl) {
        this.detectorSheetControlPanel.setSaveButtonVisible(bl);
    }

    public void setDisplayPhotonColor(ColorData colorData) {
        this.rootColor = colorData;
    }

    public QWIPanel getSchrodingerPanel() {
        return this.QWIPanel;
    }

    private void addBrightnessSlider() {
        this.detectorSheetControlPanel.setBrightnessSliderVisible(true);
    }

    private void addFadeCheckBox() {
        this.detectorSheetControlPanel.setFadeCheckBoxVisible(true);
    }

    public void setHighIntensityMode() {
        this.addBrightnessSlider();
        this.addFadeCheckBox();
        this.detectorSheetControlPanel.setTypeControlVisible(true);
        this.detectorSheetControlPanel.setBrightness();
    }

    public DetectorSheetControlPanel getDetectorSheetControlPanel() {
        return this.detectorSheetControlPanel;
    }

    public PNode getDetectorSheetControlPanelPNode() {
        return this.detectorSheetControlPanelPNode;
    }

    public int getDetectorHeight() {
        return this.detectorSheetHeight;
    }

    public void histogramChanged() {
        this.screenGraphic.repaint();
    }

    public void updatePSwing() {
        this.detectorSheetControlPanelPNode.updateBounds();
    }

    public void setTitle(String string) {
        this.title.setText(string);
    }

    public static interface Listener {
        public void brightnessChanged();
    }

    private class MyConnectorGraphic
    extends PNode {
        private PPath path = new PPath();
        private BufferedImage txtr;

        public MyConnectorGraphic() {
            this.path.setStrokePaint(Color.darkGray);
            this.addChild(this.path);
            try {
                this.txtr = ImageLoader.loadBufferedImage("quantum-wave-interference/images/wire.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void update() {
            double d = this.txtr.getHeight();
            double d2 = DetectorSheetPNode.this.detectorSheetControlPanelPNode.getFullBounds().getCenterX() - DetectorSheetPNode.this.screenGraphic.getFullBounds().getCenterX();
            Rectangle2D.Double double_ = new Rectangle2D.Double(DetectorSheetPNode.this.screenGraphic.getFullBounds().getCenterX(), DetectorSheetPNode.this.screenGraphic.getFullBounds().getCenterY() - d / 2.0, d2, d);
            this.path.setPathTo(double_);
            this.path.setPaint(new TexturePaint(this.txtr, new Rectangle2D.Double(0.0, double_.getY(), this.txtr.getWidth(), this.txtr.getHeight())));
        }
    }

    static class ScreenGraphic
    extends PNode {
        PImage screenGraphic = new PImage();
        PPath borderGraphic = new PPath();

        public ScreenGraphic(BufferedImage bufferedImage) {
            this.borderGraphic.setStrokePaint(Color.lightGray);
            this.borderGraphic.setStroke(new BasicStroke(2.0f));
            this.addChild(this.screenGraphic);
            this.addChild(this.borderGraphic);
            this.setImage(bufferedImage);
        }

        public void setImage(BufferedImage bufferedImage) {
            this.screenGraphic.setImage(bufferedImage);
            this.borderGraphic.setPathTo(new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
    }
}

