/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo;

import edu.colorado.phet.common.phetcommon.view.clock.StopwatchPanel;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.BoundNode;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.ResolutionControl;
import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.model.ParticleUnits;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.propagators.ClassicalWavePropagator;
import edu.colorado.phet.quantumwaveinterference.phetcommon.RulerGraphic;
import edu.colorado.phet.quantumwaveinterference.phetcommon.SchrodingerRulerGraphic;
import edu.colorado.phet.quantumwaveinterference.view.ClockGraphic;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunControlPanel;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.DetectorGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.HorizontalWireConnector;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.RectangularPotentialGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.WavefunctionGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.DetectorSheetPNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.IntensityManager;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.SavedScreenGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Timer;

public class QWIScreenNode
extends PNode {
    private QWIModule module;
    private QWIPanel QWIPanel;
    private WavefunctionGraphic wavefunctionGraphic;
    private ArrayList rectanglePotentialGraphics = new ArrayList();
    private ArrayList detectorGraphics = new ArrayList();
    private AbstractGunNode abstractGunNode;
    private IntensityManager intensityManager;
    private SchrodingerRulerGraphic rulerGraphic;
    private Dimension lastLayoutSize = null;
    public static int numIterationsBetwenScreenUpdate = 2;
    private DetectorSheetPNode detectorSheetPNode;
    private StopwatchPanel stopwatchPanel;
    private ParticleUnits particleUnits = new ParticleUnits.PhotonUnits();
    private Color TEXT_BACKGROUND = new Color(255, 245, 190);
    private PNode gunTypeChooserGraphic;
    private PSwing stopwatchPanelPSwing;
    private PNode gunControlPanelPSwing;
    private String slowdownText = QWIResources.getString("scale.slowing-down-time");
    private String speedupText = QWIResources.getString("scale.speeding-up-time");
    private boolean rescaleWaveGraphic = false;
    private int cellSize = 8;
    private String zoomoutText = QWIResources.getString("scale.zooming-out");
    private String zoominText = QWIResources.getString("scale.zooming-in");
    private PNode detectorScreenGraphics;
    private PNode potentialNode = new PNode();
    private double lowDT = 0.3;
    private double highDT = 4.0;
    private double ddt = 0.1;
    int MAX = 50;

    public QWIScreenNode(final QWIModule qWIModule, final QWIPanel qWIPanel) {
        this.module = qWIModule;
        this.QWIPanel = qWIPanel;
        this.wavefunctionGraphic = this.createWavefunctionGraphic();
        this.getDiscreteModel().addListener(new QWIModel.Adapter(){

            public void finishedTimeStep(QWIModel qWIModel) {
                if (qWIModel.getTimeStep() % numIterationsBetwenScreenUpdate == 0 || qWIModule.getClock().isPaused()) {
                    QWIScreenNode.this.updateWaveGraphic();
                }
            }
        });
        String[] stringArray = new String[11];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = new String(i + "");
        }
        RulerGraphic rulerGraphic = new RulerGraphic(stringArray, QWIResources.getString("units"), 500, 60);
        this.rulerGraphic = new SchrodingerRulerGraphic(this.getDiscreteModel(), qWIPanel, rulerGraphic);
        this.getDiscreteModel().addListener(new QWIModel.Adapter(){

            public void sizeChanged() {
                QWIScreenNode.this.updateRulerUnits();
                QWIScreenNode.this.layoutChildren(true);
            }
        });
        this.wavefunctionGraphic.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                QWIScreenNode.this.updateRulerUnits();
            }
        });
        this.rulerGraphic.setOffset(50.0, 200.0);
        this.setRulerVisible(false);
        this.detectorSheetPNode = new DetectorSheetPNode(qWIPanel, this.wavefunctionGraphic, 60);
        this.detectorSheetPNode.setOffset(this.wavefunctionGraphic.getX(), 0.0);
        this.intensityManager = new IntensityManager(this.getSchrodingerModule(), qWIPanel, this.detectorSheetPNode);
        this.addChild(this.detectorSheetPNode);
        this.addChild(this.wavefunctionGraphic);
        this.detectorScreenGraphics = new PNode();
        this.addChild(this.potentialNode);
        this.addChild(this.detectorScreenGraphics);
        this.addChild(this.rulerGraphic);
        qWIPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                QWIScreenNode.this.invalidateFullBounds();
                QWIScreenNode.this.repaint();
            }

            public void componentShown(ComponentEvent componentEvent) {
                QWIScreenNode.this.invalidateFullBounds();
                QWIScreenNode.this.repaint();
            }
        });
        this.layoutChildren();
        this.stopwatchPanel = new StopwatchPanel(qWIPanel.getSchrodingerModule().getClock(), QWIResources.getString("ps"), 1.0, new DecimalFormat("0.00"));
        this.getDiscreteModel().addListener(new QWIModel.Adapter(){

            public void sizeChanged() {
                QWIScreenNode.this.stopwatchPanel.reset();
            }
        });
        this.stopwatchPanel.getTimeDisplay().setEditable(false);
        this.stopwatchPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.stopwatchPanelPSwing = new PSwing(this.stopwatchPanel);
        this.stopwatchPanelPSwing.addInputEventListener(new CursorHandler(12));
        this.stopwatchPanelPSwing.addInputEventListener(new PDragEventHandler(){

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                if (!qWIPanel.getBounds().contains(QWIScreenNode.this.stopwatchPanelPSwing.getFullBounds())) {
                    QWIScreenNode.this.stopwatchPanelPSwing.setOffset(300.0, 300.0);
                }
            }
        });
        this.addChild(this.stopwatchPanelPSwing);
        this.stopwatchPanelPSwing.setOffset(300.0, 300.0);
        this.setStopwatchVisible(false);
        qWIModule.getQWIModel().addListener(new QWIModel.Adapter(){

            public void sizeChanged() {
                QWIScreenNode.this.setUnits(QWIScreenNode.this.particleUnits);
            }
        });
        qWIModule.getQWIModel().addListener(new QWIModel.Adapter(){

            public void potentialChanged() {
                QWIScreenNode.this.updateWaveGraphic();
            }

            public void doubleSlitVisibilityChanged() {
                QWIScreenNode.this.updateWaveGraphic();
            }
        });
    }

    protected WavefunctionGraphic createWavefunctionGraphic() {
        return new WavefunctionGraphic(this.getDiscreteModel(), this.module.getQWIModel().getWavefunction());
    }

    public WavefunctionGraphic getWavefunctionGraphic() {
        return this.wavefunctionGraphic;
    }

    protected QWIModel getDiscreteModel() {
        return this.getSchrodingerModule().getQWIModel();
    }

    private QWIModule getSchrodingerModule() {
        return this.QWIPanel.getSchrodingerModule();
    }

    public void setGunGraphic(AbstractGunNode abstractGunNode) {
        if (abstractGunNode != null && this.getChildrenReference().contains(abstractGunNode)) {
            this.removeChild(abstractGunNode);
        }
        this.abstractGunNode = abstractGunNode;
        int n = 0;
        if (this.getChildrenReference().contains(this.wavefunctionGraphic)) {
            n = this.getChildrenReference().indexOf(this.wavefunctionGraphic);
        }
        this.addChild(n + 1, abstractGunNode);
        this.invalidateLayout();
        this.repaint();
    }

    private int getGunGraphicOffsetY() {
        return 50;
    }

    public void setRulerVisible(boolean bl) {
        this.rulerGraphic.setVisible(bl);
    }

    public void reset() {
        this.detectorSheetPNode.reset();
        this.intensityManager.reset();
    }

    public void addDetectorGraphic(DetectorGraphic detectorGraphic) {
        this.detectorGraphics.add(detectorGraphic);
        this.addChild(detectorGraphic);
    }

    public void addRectangularPotentialGraphic(RectangularPotentialGraphic rectangularPotentialGraphic) {
        this.rectanglePotentialGraphics.add(rectangularPotentialGraphic);
        this.potentialNode.addChild(rectangularPotentialGraphic);
    }

    public void clearPotential() {
        while (this.rectanglePotentialGraphics.size() > 0) {
            this.removePotentialGraphic((RectangularPotentialGraphic)this.rectanglePotentialGraphics.get(0));
        }
    }

    public IntensityManager getIntensityDisplay() {
        return this.intensityManager;
    }

    public AbstractGunNode getGunGraphic() {
        return this.abstractGunNode;
    }

    public void removeDetectorGraphic(DetectorGraphic detectorGraphic) {
        this.removeChild(detectorGraphic);
        this.getDiscreteModel().removeDetector(detectorGraphic.getDetector());
        this.detectorGraphics.remove(detectorGraphic);
    }

    public DetectorGraphic getDetectorGraphic(Detector detector) {
        for (int i = 0; i < this.detectorGraphics.size(); ++i) {
            DetectorGraphic detectorGraphic = (DetectorGraphic)this.detectorGraphics.get(i);
            if (detectorGraphic.getDetector() != detector) continue;
            return detectorGraphic;
        }
        return null;
    }

    public void setWaveGraphicGridSize(int n, int n2) {
        this.wavefunctionGraphic.setGridDimensions(n, n2);
        this.relayout();
    }

    public void relayout() {
        this.layoutChildren(true);
    }

    protected void layoutChildren() {
        this.layoutChildren(false);
    }

    protected void layoutChildren(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.lastLayoutSize == null || !this.lastLayoutSize.equals(this.QWIPanel.getSize());
        if (bl2 || bl) {
            this.lastLayoutSize = new Dimension(this.QWIPanel.getSize());
            super.layoutChildren();
            if (this.QWIPanel.getWidth() > 0 && this.QWIPanel.getHeight() > 0) {
                double d;
                double d2;
                this.wavefunctionGraphic.setCellDimensions(this.getCellDimensions());
                int n = this.wavefunctionGraphic.getColorGrid().getBufferedImage().getWidth();
                int n2 = this.getWavefunctionGraphic().getWavefunction().getWidth();
                double d3 = this.getLayoutMinX();
                double d4 = Math.max(this.detectorSheetPNode.getFullBounds().getMaxX(), this.abstractGunNode.getFullBounds().getMaxX());
                double d5 = d4 - d3;
                double d6 = (double)this.QWIPanel.getWidth() - d5;
                double d7 = this.getWavefunctionGraphicX(d6);
                this.wavefunctionGraphic.setOffset(d7, this.detectorSheetPNode.getDetectorHeight());
                this.detectorSheetPNode.setAlignment(this.wavefunctionGraphic);
                this.abstractGunNode.setOffset(this.wavefunctionGraphic.getFullBounds().getCenterX() - (double)(this.abstractGunNode.getGunWidth() / 2) + 10.0, this.wavefunctionGraphic.getFullBounds().getMaxY() - (double)this.getGunGraphicOffsetY());
                if (this.gunControlPanelPSwing != null) {
                    d2 = 5.0;
                    d = this.QWIPanel.getHeight();
                    Point2D.Double double_ = new Point2D.Double();
                    this.detectorSheetPNode.getDetectorSheetControlPanelPNode().localToGlobal(double_);
                    this.globalToLocal(double_);
                    double d8 = this.abstractGunNode.getFullBounds().getCenterY() - this.gunControlPanelPSwing.getFullBounds().getHeight() / 2.0;
                    double d9 = d - this.gunControlPanelPSwing.getFullBounds().getHeight() - d2;
                    double d10 = Math.min(d8, d9);
                    this.gunControlPanelPSwing.setOffset(((Point2D)double_).getX(), d10);
                }
                if (this.gunTypeChooserGraphic != null) {
                    this.gunTypeChooserGraphic.setOffset(this.gunControlPanelPSwing.getFullBounds().getCenterX() - this.gunTypeChooserGraphic.getFullBounds().getWidth() / 2.0, this.gunControlPanelPSwing.getFullBounds().getY() - this.gunTypeChooserGraphic.getFullBounds().getHeight() - 2.0);
                }
                if (this.rescaleWaveGraphic) {
                    this.wavefunctionGraphic.setScale(1.0);
                    d2 = (double)this.getAvailableWaveAreaSize().width / this.wavefunctionGraphic.getFullBounds().getWidth();
                    d = (double)this.getAvailableWaveAreaSize().height / this.wavefunctionGraphic.getFullBounds().getHeight();
                    double d11 = Math.min(d2, d);
                    this.wavefunctionGraphic.setScale(d11);
                }
            }
        }
    }

    protected double getLayoutMinX() {
        return Math.min(this.detectorSheetPNode.getFullBounds().getMinX(), this.abstractGunNode.getFullBounds().getMinX());
    }

    protected double getWavefunctionGraphicX(double d) {
        return d / 2.0;
    }

    private Dimension getCellDimensions() {
        Dimension dimension = this.getAvailableWaveAreaSize();
        int n = this.QWIPanel.getDiscreteModel().getGridWidth() + 5;
        int n2 = this.QWIPanel.getDiscreteModel().getGridHeight() + 5;
        int n3 = dimension.width / n;
        int n4 = dimension.height / n2;
        int n5 = Math.min(n3, n4);
        return new Dimension(n5, n5);
    }

    public Dimension getAvailableWaveAreaSize() {
        Dimension dimension = this.QWIPanel.getSize();
        dimension.width = (int)((double)dimension.width - this.getDetectorSheetControlPanelNode().getFullBounds().getWidth());
        dimension.width -= 20;
        dimension.height = (int)((double)dimension.height - this.abstractGunNode.getFullBounds().getHeight());
        dimension.height -= 20;
        return new Dimension(dimension.width, dimension.height);
    }

    private PNode getDetectorSheetControlPanelNode() {
        return this.detectorSheetPNode.getDetectorSheetControlPanelPNode();
    }

    public void removePotentialGraphic(RectangularPotentialGraphic rectangularPotentialGraphic) {
        this.potentialNode.removeChild(rectangularPotentialGraphic);
        this.rectanglePotentialGraphics.remove(rectangularPotentialGraphic);
    }

    public DetectorSheetPNode getDetectorSheetPNode() {
        return this.detectorSheetPNode;
    }

    public void setUnits(ParticleUnits particleUnits) {
        if (particleUnits == null) {
            return;
        }
        String string = this.particleUnits.getDt().getUnits();
        double d = this.particleUnits.getLatticeWidth();
        this.particleUnits = particleUnits;
        this.updateRulerUnits();
        this.stopwatchPanel.setTimeUnits(particleUnits.getDt().getUnits());
        this.stopwatchPanel.setScaleFactor(this.getTimeFudgeFactor() * particleUnits.getDt().getDisplayValue() * particleUnits.getTimeScaleFactor());
        this.stopwatchPanel.setTimeFormat(new DecimalFormat("0.000"));
        this.stopwatchPanel.reset();
        String string2 = particleUnits.getDt().getUnits();
        String[] stringArray = new String[]{QWIResources.getString("ns"), QWIResources.getString("ps"), QWIResources.getString("fs")};
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n = arrayList.indexOf(string2) - arrayList.indexOf(string);
        if (n != 0) {
            if (n > 0) {
                this.showTimeSpeedUp();
            } else if (n < 0) {
                this.showTimeSlowDown();
            }
        }
        this.rulerGraphic.setUnits(particleUnits.getDx().getUnits());
        if (particleUnits.getLatticeWidth() != d) {
            this.showLatticeSizeChange(d);
        }
    }

    private double getTimeFudgeFactor() {
        ResolutionControl.ResolutionSetup resolutionSetup = this.module.getResolution();
        if (this.module.getQWIModel().getPropagator() instanceof ClassicalWavePropagator) {
            return resolutionSetup.getTimeFudgeFactorForLight();
        }
        return resolutionSetup.getTimeFudgeFactorForParticles();
    }

    private void showLatticeSizeChange(double d) {
        if (this.particleUnits.getLatticeWidth() > d) {
            this.showZoomIn();
        } else if (this.particleUnits.getLatticeWidth() < d) {
            this.showZoomOut();
        }
    }

    protected void showZoomOut() {
        PImage pImage = PImageFactory.create("quantum-wave-interference/images/glassMinus.gif");
        this.showZoom(pImage, this.zoomoutText);
    }

    protected void showZoom(final PImage pImage, String string) {
        final Timer timer = new Timer(0, null);
        timer.setInitialDelay(3000);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QWIScreenNode.this.removeChild(pImage);
                timer.stop();
            }
        };
        timer.addActionListener(actionListener);
        this.addChild(pImage);
        PText pText = new PText(string);
        pText.setTextPaint(Color.blue);
        pText.setOffset(0.0, pImage.getFullBounds().getHeight() + 10.0);
        BoundNode boundNode = new BoundNode(pText, 4.0, 4.0);
        boundNode.setPaint(this.TEXT_BACKGROUND);
        pImage.addChild(boundNode);
        pImage.addChild(pText);
        pImage.setOffset(this.wavefunctionGraphic.getFullBounds().getCenterX() - pImage.getFullBounds().getWidth() / 2.0, this.wavefunctionGraphic.getFullBounds().getCenterY() - pImage.getFullBounds().getHeight() / 2.0);
        timer.start();
    }

    private void showZoomIn() {
        PImage pImage = PImageFactory.create("quantum-wave-interference/images/glassPlus.gif");
        this.showZoom(pImage, this.zoominText);
    }

    private void updateRulerUnits() {
        String[] stringArray = new String[this.particleUnits.getNumRulerReadings()];
        double d = this.particleUnits.getRulerWidth() / (double)(stringArray.length - 1);
        for (int i = 0; i < stringArray.length; ++i) {
            double d2 = (double)i * d;
            stringArray[i] = new String("" + this.particleUnits.getRulerFormat().format(d2) + "");
        }
        this.rulerGraphic.getRulerGraphic().setReadings(stringArray);
        double d3 = (double)this.wavefunctionGraphic.getWavefunctionGraphicWidth() * this.particleUnits.getRulerWidth() / this.particleUnits.getLatticeWidth();
        this.rulerGraphic.getRulerGraphic().setMeasurementPixelWidth(d3);
        this.rulerGraphic.setUnits(this.particleUnits.getDx().getUnits());
    }

    private void showTimeSpeedUp() {
        final ClockGraphic clockGraphic = new ClockGraphic();
        final Timer timer = new Timer(30, null);
        ActionListener actionListener = new ActionListener(){
            double dt;
            double t;
            int numAfter;
            {
                this.dt = QWIScreenNode.this.lowDT;
                this.t = 0.0;
                this.numAfter = 0;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.t += this.dt;
                if (!(this.dt < QWIScreenNode.this.lowDT) && !(this.dt > QWIScreenNode.this.highDT)) {
                    this.dt += QWIScreenNode.this.ddt;
                }
                clockGraphic.setTime(this.t / 10.0);
                if (this.dt < QWIScreenNode.this.lowDT || this.dt > QWIScreenNode.this.highDT) {
                    ++this.numAfter;
                    if (this.numAfter > QWIScreenNode.this.MAX) {
                        timer.stop();
                        QWIScreenNode.this.removeChild(clockGraphic);
                    }
                }
            }
        };
        timer.addActionListener(actionListener);
        this.addChild(clockGraphic);
        PText pText = new PText(this.speedupText);
        pText.setTextPaint(Color.blue);
        BoundNode boundNode = new BoundNode(pText, 4.0, 4.0);
        boundNode.setPaint(this.TEXT_BACKGROUND);
        clockGraphic.addChild(boundNode);
        clockGraphic.addChild(pText);
        clockGraphic.setOffset(this.abstractGunNode.getFullBounds().getX(), this.abstractGunNode.getFullBounds().getY());
        timer.start();
    }

    private void showTimeSlowDown() {
        final ClockGraphic clockGraphic = new ClockGraphic();
        final Timer timer = new Timer(30, null);
        ActionListener actionListener = new ActionListener(){
            double dt;
            double t;
            int numAfter;
            {
                this.dt = QWIScreenNode.this.highDT;
                this.t = 0.0;
                this.numAfter = 0;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.t += this.dt;
                if (!(this.dt < QWIScreenNode.this.lowDT) && !(this.dt > QWIScreenNode.this.highDT)) {
                    this.dt -= QWIScreenNode.this.ddt;
                }
                clockGraphic.setTime(this.t / 10.0);
                if (this.dt < QWIScreenNode.this.lowDT || this.dt > QWIScreenNode.this.highDT) {
                    ++this.numAfter;
                    if (this.numAfter > QWIScreenNode.this.MAX) {
                        timer.stop();
                        QWIScreenNode.this.removeChild(clockGraphic);
                    }
                }
            }
        };
        timer.addActionListener(actionListener);
        this.addChild(clockGraphic);
        PText pText = new PText(this.slowdownText);
        pText.setTextPaint(Color.blue);
        BoundNode boundNode = new BoundNode(pText, 4.0, 4.0);
        boundNode.setPaint(this.TEXT_BACKGROUND);
        clockGraphic.addChild(boundNode);
        clockGraphic.addChild(pText);
        clockGraphic.setOffset(this.abstractGunNode.getFullBounds().getX(), this.abstractGunNode.getFullBounds().getY());
        timer.start();
    }

    public void setGunTypeChooserGraphic(PNode pNode) {
        this.addChild(pNode);
        this.gunTypeChooserGraphic = pNode;
        this.invalidateLayout();
        this.repaint();
    }

    public void setStopwatchVisible(boolean bl) {
        this.stopwatchPanelPSwing.setVisible(bl);
    }

    public boolean isRulerVisible() {
        return this.rulerGraphic.getVisible();
    }

    public void updateWaveGraphic() {
        this.wavefunctionGraphic.update();
    }

    public void setGunControlPanel(GunControlPanel gunControlPanel) {
        if (gunControlPanel == null) {
            if (this.gunControlPanelPSwing != null) {
                this.removeChild(this.gunControlPanelPSwing);
            }
            this.gunControlPanelPSwing = null;
            this.relayout();
        } else {
            int n = 0;
            if (this.getChildrenReference().contains(this.abstractGunNode)) {
                n = this.getChildrenReference().indexOf(this.abstractGunNode);
            }
            this.addChild(n, gunControlPanel.getPSwing());
            this.gunControlPanelPSwing = gunControlPanel.getPSwing();
            this.relayout();
            HorizontalWireConnector horizontalWireConnector = new HorizontalWireConnector(this.gunControlPanelPSwing, this.abstractGunNode);
            this.addChild(n, horizontalWireConnector);
        }
    }

    public void setCellSize(int n) {
        if (this.cellSize != n) {
            this.cellSize = n;
        }
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void addSavedScreenGraphic(SavedScreenGraphic savedScreenGraphic) {
        this.detectorScreenGraphics.addChild(savedScreenGraphic);
    }

    public void removeSavedScreenGraphic(SavedScreenGraphic savedScreenGraphic) {
        this.detectorScreenGraphics.removeChild(savedScreenGraphic);
    }

    public QWIModel getQWIModel() {
        return this.getDiscreteModel();
    }
}

