/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.quantumwaveinterference.controls.ResolutionControl;
import edu.colorado.phet.quantumwaveinterference.controls.SRRWavelengthSlider;
import edu.colorado.phet.quantumwaveinterference.model.ParticleUnits;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.WaveSetup;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.propagators.ClassicalWavePropagator;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.SRRWavelengthSliderComponent;

public class Photon
extends GunParticle {
    private SRRWavelengthSlider wavelengthSliderGraphic;
    private ParticleUnits.PhotonUnits photonUnits;

    public Photon(AbstractGunNode abstractGunNode, String string, String string2) {
        super(abstractGunNode, string, string2);
        this.wavelengthSliderGraphic = new SRRWavelengthSlider(abstractGunNode.getSchrodingerPanel());
        this.getDiscreteModel().addListener(new QWIModel.Adapter(){

            public void sizeChanged() {
                Photon.this.notifyMomentumChanged();
            }
        });
        this.photonUnits = new ParticleUnits.PhotonUnits();
    }

    public void activate(AbstractGunNode abstractGunNode) {
        this.active = true;
        this.getSchrodingerModule().setUnits(this.photonUnits);
        this.getGunGraphic().getSchrodingerPanel().setPhoton(this);
        abstractGunNode.getSchrodingerModule().getQWIModel().setPropagatorClassical();
        SRRWavelengthSliderComponent sRRWavelengthSliderComponent = new SRRWavelengthSliderComponent(this.wavelengthSliderGraphic);
        abstractGunNode.setGunControls(sRRWavelengthSliderComponent);
    }

    public void deactivate(AbstractGunNode abstractGunNode) {
        this.active = false;
        abstractGunNode.removeGunControls();
    }

    public void fireParticle() {
        Propagator propagator = this.getGunGraphic().getDiscreteModel().getPropagator();
        if (propagator instanceof ClassicalWavePropagator) {
            ClassicalWavePropagator classicalWavePropagator = (ClassicalWavePropagator)propagator;
            WaveSetup waveSetup = this.getInitialWavefunction(this.getGunGraphic().getDiscreteModel().getWavefunction());
            Wavefunction wavefunction = this.getGunGraphic().getDiscreteModel().getWavefunction().createEmptyWavefunction();
            waveSetup.initialize(wavefunction);
            classicalWavePropagator.addInitialization(wavefunction, wavefunction);
        }
        super.fireParticle();
    }

    public boolean isFiring() {
        return false;
    }

    public double getMinimumProbabilityForDetection() {
        return 0.05;
    }

    public boolean getTimeThresholdAllowed() {
        return true;
    }

    public int getTimeThresholdCount() {
        return 30;
    }

    protected double getStartY() {
        return (double)this.getDiscreteModel().getGridHeight() * 0.9;
    }

    public double getStartPy() {
        double d = this.getWavelength() * (double)this.getDiscreteModel().getGridHeight() / (double)ResolutionControl.INIT_WAVE_SIZE;
        return Math.PI * 2 / d;
    }

    protected double getHBar() {
        return 1.0;
    }

    public double getWavelengthNM() {
        return this.wavelengthSliderGraphic.getWavelength();
    }

    private double getWavelength() {
        double d = this.wavelengthSliderGraphic.getWavelength();
        return new Function.LinearFunction(380.0, 780.0, 13.333333333333334, 23.333333333333332).evaluate(d);
    }

    protected void detachListener(GunParticle.ChangeHandler changeHandler) {
        this.wavelengthSliderGraphic.removeChangeListener(changeHandler);
    }

    protected void hookupListener(GunParticle.ChangeHandler changeHandler) {
        this.wavelengthSliderGraphic.addChangeListener(changeHandler);
    }

    public void autofire() {
    }

    public ColorData getRootColor() {
        return new ColorData(this.getWavelengthNM());
    }
}

