/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.quantumwaveinterference.view.gun.OnOffItem;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;

public class OnOffCheckBox
extends JCheckBox {
    public OnOffCheckBox(final OnOffItem onOffItem) {
        super("", onOffItem.isOn());
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                onOffItem.setOn(OnOffCheckBox.this.isSelected());
            }
        });
        this.setFont(new PhetFont(13, true));
        try {
            ImageIcon imageIcon = new ImageIcon(ImageLoader.loadBufferedImage("quantum-wave-interference/images/button-in-40.gif"));
            ImageIcon imageIcon2 = new ImageIcon(ImageLoader.loadBufferedImage("quantum-wave-interference/images/button-out-40.gif"));
            this.setIcon(new ToggleIcon(imageIcon, imageIcon2));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setOpaque(false);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
    }

    class ToggleIcon
    implements Icon {
        Icon on;
        Icon off;

        public ToggleIcon(Icon icon, Icon icon2) {
            this.on = icon;
            this.off = icon2;
        }

        public int getIconHeight() {
            return this.getCurrentIcon().getIconHeight();
        }

        private Icon getCurrentIcon() {
            return OnOffCheckBox.this.isSelected() ? this.on : this.off;
        }

        public int getIconWidth() {
            return this.getCurrentIcon().getIconHeight();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.getCurrentIcon().paintIcon(component, graphics, n, n2);
        }
    }
}

