/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.phetcommon.ShinyPanel;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class GunControlPanel
extends VerticalLayoutPanel {
    private JComponent gunControl;
    private ShinyPanel shinyPanel;
    private PSwing gunControlPSwing;
    private JLabel titleLabel;

    public GunControlPanel(QWIPanel qWIPanel) {
        this.setOpaque(false);
        this.shinyPanel = new ShinyGunControlPanel(this);
        this.gunControlPSwing = new PSwing(this.shinyPanel);
        this.titleLabel = new JLabel(QWIResources.getString("gun.controls")){

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(graphics);
            }
        };
        this.titleLabel.setForeground(Color.white);
        this.titleLabel.setOpaque(false);
        this.titleLabel.setFont(new PhetFont(1, 14));
        this.add(this.titleLabel);
    }

    protected JLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void setGunControls(JComponent jComponent) {
        if (this.gunControl != null) {
            this.remove(this.gunControl);
        }
        this.gunControl = jComponent;
        if (jComponent != null) {
            this.addFullWidth(jComponent);
            jComponent.setDoubleBuffered(false);
            this.shinyPanel.update();
        }
        this.invalidate();
        this.doLayout();
        this.gunControlPSwing.updateBounds();
        this.gunControlPSwing.getComponent().invalidate();
        this.gunControlPSwing.getComponent().revalidate();
        this.gunControlPSwing.getComponent().repaint();
        this.gunControlPSwing.getComponent().doLayout();
    }

    public PNode getPSwing() {
        return this.gunControlPSwing;
    }

    public Component add(Component component) {
        this.init(component);
        return super.add(component);
    }

    void init(Component component) {
        Component[] componentArray = null;
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.init(componentArray[i]);
            }
        }
        if (component instanceof JComponent) {
            ((JComponent)component).setDoubleBuffered(false);
        }
    }

    static class ShinyGunControlPanel
    extends ShinyPanel {
        public ShinyGunControlPanel(JComponent jComponent) {
            super(jComponent, new Color(91, 91, 91), new Color(80, 80, 80));
        }
    }
}

