/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.FireParticle;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class FireButton
extends JButton {
    private ImageIcon outIcon;
    private ImageIcon inIcon;
    private FireParticle fireParticle;

    public FireButton(FireParticle fireParticle) {
        super(QWIResources.getString("gun.fire"));
        this.fireParticle = fireParticle;
        this.setFont(new PhetFont(1, 18));
        this.setForeground(Color.red);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        try {
            this.outIcon = new ImageIcon(ImageLoader.loadBufferedImage("quantum-wave-interference/images/button-out-40.gif"));
            this.inIcon = new ImageIcon(ImageLoader.loadBufferedImage("quantum-wave-interference/images/button-in-40.gif"));
            this.setIcon(this.outIcon);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (FireButton.this.fireButtonEnabled()) {
                    FireButton.this.setIcon(FireButton.this.inIcon);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (FireButton.this.fireButtonEnabled()) {
                    FireButton.this.setIcon(FireButton.this.outIcon);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FireButton.this.fireParticle();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                FireButton.this.pullback();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                FireButton.this.releasePullback();
            }
        });
    }

    private void releasePullback() {
        if (this.fireButtonEnabled()) {
            this.updateGunLocation();
        }
    }

    private void pullback() {
        if (this.fireButtonEnabled()) {
            this.updateGunLocation();
            this.getGunImageGraphic().translate(0.0, 10.0);
        }
    }

    private void fireParticle() {
        this.clearAndFire();
        this.setIcon(this.outIcon);
        this.updateGunLocation();
        this.getSchrodingerPanel().setCursor(Cursor.getPredefinedCursor(0));
    }

    private boolean fireButtonEnabled() {
        return this.isEnabled();
    }

    private QWIModule getSchrodingerModule() {
        return this.fireParticle.getSchrodingerModule();
    }

    private QWIPanel getSchrodingerPanel() {
        return this.getSchrodingerModule().getSchrodingerPanel();
    }

    private void updateGunLocation() {
        this.fireParticle.updateGunLocation();
    }

    private void clearAndFire() {
        this.fireParticle.clearAndFire();
    }

    private PNode getGunImageGraphic() {
        return this.fireParticle.getGunImageGraphic();
    }
}

