/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.phetcommon.ImagePComboBox;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunControlPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;

public abstract class AbstractGunNode
extends PNode {
    private QWIPanel QWIPanel;
    private PImage gunImageGraphic;
    private ArrayList listeners = new ArrayList();
    private ImagePComboBox comboBox;
    private PNode onGunGraphic;

    public AbstractGunNode(QWIPanel qWIPanel) {
        this.QWIPanel = qWIPanel;
        try {
            BufferedImage bufferedImage = ImageLoader.loadBufferedImage("quantum-wave-interference/images/ray-gun.png");
            this.gunImageGraphic = new PImage(bufferedImage);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addChild(this.gunImageGraphic);
        this.onGunGraphic = new PSwing(new JButton(QWIResources.getString("gun.fire")));
        this.addChild(this.onGunGraphic);
        this.comboBox = this.initComboBox();
        this.updateGunLocation();
        this.setVisible(true);
    }

    public PNode getOnGunGraphic() {
        return this.onGunGraphic;
    }

    public abstract GunControlPanel getGunControlPanel();

    public abstract boolean isPhotonMode();

    protected void setOnGunControl(PNode pNode) {
        if (this.onGunGraphic != null) {
            this.removeChild(this.onGunGraphic);
        }
        this.onGunGraphic = pNode;
        this.addChild(this.onGunGraphic);
        this.QWIPanel.invalidate();
        this.QWIPanel.doLayout();
        this.QWIPanel.repaint();
        this.invalidateLayout();
        this.repaint();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.onGunGraphic.setOffset(this.gunImageGraphic.getFullBounds().getX() + this.gunImageGraphic.getFullBounds().getWidth() / 2.0 - this.onGunGraphic.getFullBounds().getWidth() / 2.0 + -3.0, 77.0 + this.gunImageGraphic.getFullBounds().getY());
    }

    public void updateGunLocation() {
        this.gunImageGraphic.setOffset(this.getGunLocation());
        this.layoutChildren();
    }

    protected abstract Point getGunLocation();

    protected abstract ImagePComboBox initComboBox();

    public QWIModel getDiscreteModel() {
        return this.QWIPanel.getDiscreteModel();
    }

    public PImage getGunImageGraphic() {
        return this.gunImageGraphic;
    }

    public QWIModule getSchrodingerModule() {
        return this.QWIPanel.getSchrodingerModule();
    }

    public ImagePComboBox getComboBox() {
        return this.comboBox;
    }

    public int getGunWidth() {
        return (int)this.gunImageGraphic.getFullBounds().getWidth();
    }

    public QWIPanel getSchrodingerPanel() {
        return this.QWIPanel;
    }

    protected abstract void setGunControls(JComponent var1);

    public void removeGunControls() {
        this.setGunControls(null);
    }

    public Map getModelParameters() {
        return new HashMap();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean containsListener(Listener listener) {
        return this.listeners.contains(listener);
    }

    protected void notifyGunFired() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.gunFired();
        }
    }

    public static interface Listener {
        public void gunFired();
    }

    public static interface MomentumChangeListener {
        public void momentumChanged(double var1);
    }
}

