/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.colorgrid;

import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorMap;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class ColorGrid {
    private BufferedImage image;
    private int cellWidth;
    private int cellHeight;
    private int nx;
    private int ny;
    private ArrayList listeners = new ArrayList();

    public ColorGrid(int n, int n2, int n3, int n4) {
        this.cellWidth = n;
        this.cellHeight = n2;
        this.nx = n3;
        this.ny = n4;
        this.createImage();
    }

    private void createImage() {
        int n = this.nx * this.getCellWidth();
        int n2 = this.ny * this.getCellHeight();
        if (n <= 0) {
            n = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        this.image = new BufferedImage(n, n2, 1);
    }

    public void colorize(ColorMap colorMap) {
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        int n = this.getCellWidth();
        int n2 = this.getCellHeight();
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                Paint paint = colorMap.getColor(i, j);
                graphics2D.setPaint(paint);
                graphics2D.fillRect(i * n, j * n2, n, n2);
            }
        }
        graphics2D.dispose();
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public Rectangle getViewRectangle(Rectangle rectangle) {
        int n = this.getCellWidth();
        int n2 = this.getCellHeight();
        return new Rectangle(rectangle.x * n, rectangle.y * n2, rectangle.width * n, rectangle.height * n2);
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public void setModelSize(int n, int n2) {
        if (this.nx != n || this.ny != n2) {
            this.nx = n;
            this.ny = n2;
            this.createImage();
            this.notifyListeners();
        }
    }

    public void setCellDimensions(int n, int n2) {
        if (this.cellWidth != n || this.cellHeight != n2) {
            this.cellWidth = n;
            this.cellHeight = n2;
            this.createImage();
            this.notifyListeners();
        }
    }

    private void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.update();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void update();
    }
}

