/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.PDebugKeyHandler;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.model.ParticleUnits;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.view.DebugSymmetry;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorMap;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.PhotonColorMap;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.WaveValueAccessor;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.ComplexColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.ComplexColorMapAdapter;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.MagnitudeColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.VisualColorMap3;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunControlPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.Photon;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.DetectorGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.QWIScreenNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.RectangularPotentialGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.WavefunctionGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.DetectorSheetPNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.IntensityManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class QWIPanel
extends BufferedPhetPCanvas {
    private QWIModel QWIModel;
    private QWIModule module;
    private Photon photon;
    private QWIScreenNode QWIScreenNode;
    private boolean fadeEnabled = true;
    private ArrayList listeners = new ArrayList();
    private boolean inverseSlits = false;
    private ComplexColorMap complexColorMap = new MagnitudeColorMap();
    private WaveValueAccessor waveValueAccessor = new WaveValueAccessor.Magnitude();
    private AbstractGunNode.Listener fireListener = new AbstractGunNode.Listener(){

        public void gunFired() {
            QWIPanel.this.doGunFired();
        }
    };

    public QWIPanel(QWIModule qWIModule) {
        this.setLayout(null);
        this.module = qWIModule;
        this.QWIModel = qWIModule.getQWIModel();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                QWIPanel.this.setRenderingSize(600, 600);
                QWIPanel.this.QWIScreenNode.relayout();
            }
        });
        this.addKeyListener(new PDebugKeyHandler());
        this.addKeyListener(new DebugSymmetry(qWIModule));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                QWIPanel.this.requestFocus();
            }
        });
        this.getSchrodingerModule().getModel().addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                QWIPanel.this.updateScreen();
            }
        });
        this.QWIScreenNode = this.createSchrodingerScreenNode(qWIModule);
        this.getPhetRootNode().addScreenChild(this.QWIScreenNode);
        this.setBackground(new Color(170, 210, 255));
        this.addListener(new Adapter(){

            public void inverseSlitsChanged() {
                QWIPanel.this.synchronizeSlitInverse();
            }
        });
        this.synchronizeSlitInverse();
    }

    protected QWIScreenNode createSchrodingerScreenNode(QWIModule qWIModule) {
        return new QWIScreenNode(qWIModule, this);
    }

    private void doGunFired() {
        this.QWIModel.gunFired();
    }

    private void synchronizeSlitInverse() {
        this.QWIModel.getDoubleSlitPotential().setInverseSlits(this.inverseSlits);
    }

    private void setRenderingSize(int n, int n2) {
        super.setWorldTransformStrategy(new PhetPCanvas.RenderingSizeStrategy(this, new Dimension(n, n2)));
    }

    protected void updateScreen() {
        this.getIntensityDisplay().tryDetecting();
    }

    protected void setGunGraphic(AbstractGunNode abstractGunNode) {
        this.QWIScreenNode.setGunGraphic(abstractGunNode);
        if (!abstractGunNode.containsListener(this.fireListener)) {
            abstractGunNode.addListener(this.fireListener);
        }
    }

    public void setRulerVisible(boolean bl) {
        this.QWIScreenNode.setRulerVisible(bl);
    }

    public void reset() {
        this.QWIScreenNode.reset();
    }

    public QWIModel getDiscreteModel() {
        return this.QWIModel;
    }

    public void addDetectorGraphic(DetectorGraphic detectorGraphic) {
        this.QWIScreenNode.addDetectorGraphic(detectorGraphic);
    }

    public void addRectangularPotentialGraphic(RectangularPotentialGraphic rectangularPotentialGraphic) {
        this.QWIScreenNode.addRectangularPotentialGraphic(rectangularPotentialGraphic);
    }

    public void clearPotential() {
        this.QWIScreenNode.clearPotential();
    }

    public WavefunctionGraphic getWavefunctionGraphic() {
        return this.QWIScreenNode.getWavefunctionGraphic();
    }

    public QWIModule getSchrodingerModule() {
        return this.module;
    }

    public IntensityManager getIntensityDisplay() {
        return this.QWIScreenNode.getIntensityDisplay();
    }

    public DetectorSheetPNode getDetectorSheetPNode() {
        return this.QWIScreenNode.getDetectorSheetPNode();
    }

    public AbstractGunNode getGunGraphic() {
        return this.QWIScreenNode.getGunGraphic();
    }

    public void removeDetectorGraphic(DetectorGraphic detectorGraphic) {
        this.QWIScreenNode.removeDetectorGraphic(detectorGraphic);
    }

    public void addDetectorGraphic(Detector detector) {
        DetectorGraphic detectorGraphic = new DetectorGraphic(this, detector);
        this.addDetectorGraphic(detectorGraphic);
    }

    public DetectorGraphic getDetectorGraphic(Detector detector) {
        return this.QWIScreenNode.getDetectorGraphic(detector);
    }

    public void removeDetectorGraphic(Detector detector) {
        DetectorGraphic detectorGraphic = this.getDetectorGraphic(detector);
        this.removeDetectorGraphic(detectorGraphic);
    }

    public void setPhoton(Photon photon) {
        this.photon = photon;
        this.getDetectorSheetPNode().setDisplayPhotonColor(photon == null ? null : new ColorData(photon.getWavelengthNM()));
        this.update();
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.particleTypeChanged();
        }
    }

    public void update() {
        this.updateWavefunctionColorMap();
        this.updateWaveGraphic();
    }

    protected void updateWavefunctionColorMap() {
        ColorMap colorMap = this.createColorMap();
        this.getWavefunctionGraphic().setColorMap(colorMap);
    }

    public void setVisualizationStyle(ComplexColorMap complexColorMap, WaveValueAccessor waveValueAccessor) {
        if (this.complexColorMap != complexColorMap || this.waveValueAccessor != waveValueAccessor) {
            this.complexColorMap = complexColorMap;
            this.waveValueAccessor = waveValueAccessor;
            this.update();
            this.notifyVisualizationStyleChanged();
        }
    }

    private void notifyVisualizationStyleChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.visualizationStyleChanged();
        }
    }

    public WaveValueAccessor getWaveValueAccessor() {
        return this.waveValueAccessor;
    }

    protected ColorMap createColorMap() {
        if (this.photon != null && !(this.complexColorMap instanceof VisualColorMap3)) {
            if (this.waveValueAccessor instanceof WaveValueAccessor.Imag) {
                return new PhotonColorMap(this, this.photon.getWavelengthNM(), new WaveValueAccessor.Empty());
            }
            return new PhotonColorMap(this, this.photon.getWavelengthNM(), this.waveValueAccessor);
        }
        return new ComplexColorMapAdapter(this.getDiscreteModel().getWavefunction(), this.complexColorMap);
    }

    public void clearWavefunction() {
        this.getDiscreteModel().clearWavefunction();
        this.updateWaveGraphic();
        this.repaint();
    }

    public void setFadeEnabled(boolean bl) {
        this.fadeEnabled = bl;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.fadeStateChanged();
        }
    }

    public Photon getDisplayPhotonColor() {
        return this.photon;
    }

    public void setWaveSize(int n, int n2) {
        this.QWIScreenNode.setWaveGraphicGridSize(n, n2);
    }

    public void removePotentialGraphic(RectangularPotentialGraphic rectangularPotentialGraphic) {
        this.QWIScreenNode.removePotentialGraphic(rectangularPotentialGraphic);
    }

    public QWIScreenNode getSchrodingerScreenNode() {
        return this.QWIScreenNode;
    }

    public boolean isFadeEnabled() {
        return this.fadeEnabled;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean isInverseSlits() {
        return this.inverseSlits;
    }

    public void setInverseSlits(boolean bl) {
        this.inverseSlits = bl;
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.inverseSlitsChanged();
        }
    }

    public void setUnits(ParticleUnits particleUnits) {
        this.QWIScreenNode.setUnits(particleUnits);
    }

    public void setStopwatchVisible(boolean bl) {
        this.QWIScreenNode.setStopwatchVisible(bl);
    }

    public boolean isRulerVisible() {
        return this.QWIScreenNode.isRulerVisible();
    }

    public void updateWaveGraphic() {
        this.QWIScreenNode.updateWaveGraphic();
    }

    public void addGunControlPanel() {
        GunControlPanel gunControlPanel = this.getGunGraphic().getGunControlPanel();
        this.QWIScreenNode.setGunControlPanel(gunControlPanel);
    }

    public boolean isPhotonMode() {
        return this.getGunGraphic().isPhotonMode();
    }

    public void setCellSize(int n) {
        this.QWIScreenNode.setCellSize(n);
    }

    public void updateDetectorReadouts() {
        this.module.getQWIModel().getDetectorSet().updateDetectorProbabilities();
    }

    public static class Adapter
    implements Listener {
        public void fadeStateChanged() {
        }

        public void inverseSlitsChanged() {
        }

        public void visualizationStyleChanged() {
        }

        public void particleTypeChanged() {
        }
    }

    public static interface Listener {
        public void fadeStateChanged();

        public void inverseSlitsChanged();

        public void visualizationStyleChanged();

        public void particleTypeChanged();
    }
}

