/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;

public class ClockGraphic
extends PNode {
    private PImage clockImage = PImageFactory.create("quantum-wave-interference/images/clock3.png");
    private HandGraphic minuteHand;
    private HandGraphic hourHand;

    public ClockGraphic() {
        this.addChild(this.clockImage);
        this.minuteHand = new HandGraphic(20.0, 2.0);
        this.minuteHand.setAngle(0.0);
        this.addChild(this.minuteHand);
        this.hourHand = new HandGraphic(13.0, 3.0);
        this.addChild(this.hourHand);
        this.setTime(0.0);
    }

    protected Point2D getTailLocation() {
        return new Point2D.Double(this.clockImage.getWidth() / 2.0, this.clockImage.getHeight() / 2.0);
    }

    public void setTime(double d) {
        this.setMinuteHandAngle(d - 1.5707963267948966);
        this.setHourHandAngle(d / 12.0 - 1.5707963267948966);
    }

    public void setMinuteHandAngle(double d) {
        this.minuteHand.setAngle(d);
    }

    private void setHourHandAngle(double d) {
        this.hourHand.setAngle(d);
    }

    class HandGraphic
    extends PNode {
        double angle;
        double length;
        private PPath shape;
        private double headHeight = 6.0;
        private double headWidth = 8.0;
        private double tailWidth = 3.0;

        public HandGraphic(double d, double d2) {
            this.length = d;
            this.tailWidth = d2;
            this.shape = new PPath();
            this.addChild(this.shape);
            this.shape.setPaint(Color.black);
            this.shape.setStroke(new BasicStroke(0.2f));
            this.shape.setStrokePaint(Color.darkGray);
        }

        public void setAngle(double d) {
            this.angle = d;
            this.update();
        }

        private void update() {
            Arrow arrow = new Arrow(ClockGraphic.this.getTailLocation(), Vector2D.parseAngleAndMagnitude(this.length, this.angle).getDestination(ClockGraphic.this.getTailLocation()), this.headHeight, this.headWidth, this.tailWidth);
            this.shape.setPathTo(arrow.getShape());
        }
    }
}

