/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.single;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.ClearButton;
import edu.colorado.phet.quantumwaveinterference.controls.DetectorPanel;
import edu.colorado.phet.quantumwaveinterference.controls.ExpandableDoubleSlitPanel;
import edu.colorado.phet.quantumwaveinterference.controls.IVisualizationPanel;
import edu.colorado.phet.quantumwaveinterference.controls.ParticleVisualizationPanel;
import edu.colorado.phet.quantumwaveinterference.controls.PhotonVisualizationPanel;
import edu.colorado.phet.quantumwaveinterference.controls.PotentialPanel;
import edu.colorado.phet.quantumwaveinterference.controls.QWIControlPanel;
import edu.colorado.phet.quantumwaveinterference.controls.ResetButton;
import edu.colorado.phet.quantumwaveinterference.controls.VisualizationPanelContainer;
import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.modules.single.SingleParticleModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SingleParticleControlPanel
extends QWIControlPanel {
    private IVisualizationPanel particleVisPanel;
    private IVisualizationPanel photonVisPanel;
    private VisualizationPanelContainer visPanel;
    private SingleParticleModule singleParticleModule;

    public SingleParticleControlPanel(SingleParticleModule singleParticleModule) {
        super(singleParticleModule);
        this.singleParticleModule = singleParticleModule;
        AdvancedPanel advancedPanel = new AdvancedPanel(QWIResources.getString("controls.barriers.show"), QWIResources.getString("controls.barriers.hide"));
        advancedPanel.addControlFullWidth(new PotentialPanel(singleParticleModule));
        AdvancedPanel advancedPanel2 = new AdvancedPanel(QWIResources.getString("controls.detectors.show"), QWIResources.getString("controls.detectors.hide"));
        advancedPanel2.addControlFullWidth(new DetectorPanel(singleParticleModule));
        JButton jButton = new JButton(QWIResources.getString("create.detector.array"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SingleParticleControlPanel.this.createDetectorArray();
            }
        });
        final ModelSlider modelSlider = new ModelSlider(QWIResources.getString("dectector.prob.scale"), "", 0.0, 100.0, Detector.getProbabilityScaleFudgeFactor());
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Detector.setProbabilityScaleFudgeFactor(modelSlider.getValue());
            }
        });
        modelSlider.setModelTicks(new double[]{0.0, 50.0, 100.0});
        this.getAdvancedPanel().addControl(jButton);
        this.getAdvancedPanel().addControlFullWidth(modelSlider);
        this.photonVisPanel = new PhotonVisualizationPanel(this.getSchrodingerPanel());
        this.particleVisPanel = new ParticleVisualizationPanel(this.getSchrodingerPanel());
        this.visPanel = new VisualizationPanelContainer(this.photonVisPanel, this.particleVisPanel);
        singleParticleModule.addListener(new QWIModule.Listener(){

            public void deactivated() {
            }

            public void activated() {
            }

            public void beamTypeChanged() {
                SingleParticleControlPanel.this.updateVisualizationPanel();
            }
        });
        this.updateVisualizationPanel();
        ExpandableDoubleSlitPanel expandableDoubleSlitPanel = new ExpandableDoubleSlitPanel(singleParticleModule);
        this.addSeparator();
        this.addSpacer();
        this.getContentPanel().setAnchor(10);
        this.addControl(new ResetButton(singleParticleModule));
        this.addControl(new ClearButton(singleParticleModule.getSchrodingerPanel()));
        this.getContentPanel().setAnchor(17);
        this.addSpacer();
        this.addSeparator();
        this.addSpacer();
        this.addControl(this.visPanel);
        this.addControl(expandableDoubleSlitPanel);
        this.addControl(advancedPanel);
        this.addControl(advancedPanel2);
        this.setPreferredWidth(expandableDoubleSlitPanel.getControls().getPreferredSize().width + 10);
    }

    private void updateVisualizationPanel() {
        this.visPanel.setContent(this.isPhoton() ? this.photonVisPanel : this.particleVisPanel);
        this.revalidate();
    }

    private boolean isPhoton() {
        return this.getSchrodingerPanel().getGunGraphic().isPhotonMode();
    }

    private void createDetectorArray() {
        this.createDetectorArray(20);
    }

    private void createDetectorArray(int n) {
        int n2 = n;
        int n3 = this.getDiscreteModel().getGridWidth() / n;
        int n4 = this.getDiscreteModel().getGridHeight() / n2;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n5 = i * n;
                int n6 = j * n2;
                Detector detector = new Detector(this.getDiscreteModel(), n5, n6, n, n2);
                this.getSchrodingerPanel().getSchrodingerModule().addDetector(detector);
            }
        }
    }
}

