/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.mandel;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import edu.colorado.phet.quantumwaveinterference.model.waves.PlaneWave2D;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelWaveDamp;

public class MandelWave
implements Wave {
    private MandelWaveDamp leftWave;
    private MandelWaveDamp rightWave;

    public MandelWave(int n, double d, double d2, double d3, double d4, double d5, double d6, int n2) {
        PlaneWave2D planeWave2D = new PlaneWave2D(ImmutableVector2D.parseAngleAndMagnitude(d, 0.0), 100.0);
        planeWave2D.setPhase(d3);
        planeWave2D.setPhaseOffset(0.0);
        this.leftWave = new MandelWaveDamp(n, planeWave2D, d5, n2);
        PlaneWave2D planeWave2D2 = new PlaneWave2D(ImmutableVector2D.parseAngleAndMagnitude(d2, 0.0), 100.0);
        planeWave2D2.setPhaseOffset(-d4);
        int n3 = n2 - n - 1;
        this.rightWave = new MandelWaveDamp(n3, planeWave2D2, d6, n2);
    }

    public Complex getValue(int n, int n2, double d) {
        double d2 = d * 1000.0 * 3.0 * 1.2;
        return this.leftWave.getValue(n, n2, d2).plus(this.rightWave.getValue(n, n2, d2));
    }
}

