/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.mandel;

import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.DoublePhotonWave;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelGun;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelModule;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelSchrodingerPanel;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.PhotonMandelBeam;
import edu.colorado.phet.quantumwaveinterference.phetcommon.ImageComboBox;
import edu.colorado.phet.quantumwaveinterference.phetcommon.ImagePComboBox;
import edu.colorado.phet.quantumwaveinterference.view.gun.IntensityBeam;
import edu.colorado.phet.quantumwaveinterference.view.gun.IntensityGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.Photon;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.BlueGunDetails;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.PinkGunDetails;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;

public class MandelGunSet
extends IntensityGunNode {
    private MandelGun leftGun;
    private MandelGun rightGun;
    private Photon photon;
    private PhotonMandelBeam photonMandelBeam;

    public MandelGunSet(MandelSchrodingerPanel mandelSchrodingerPanel) {
        super(mandelSchrodingerPanel);
        this.leftGun = new MandelGun("quantum-wave-interference/images/mandel-gun-1.png", mandelSchrodingerPanel);
        this.leftGun.setControlsOffset(-this.leftGun.getGunControlPanelPSwing().getFullBounds().getWidth() + 50.0, 0.0);
        this.leftGun.setControlBackgroundColor(BlueGunDetails.gunBackgroundColor);
        this.leftGun.translateOnGunControls(0, 5);
        this.rightGun = new MandelGun("quantum-wave-interference/images/mandel-gun-2.png", mandelSchrodingerPanel);
        this.rightGun.setControlsOffset(this.rightGun.getGunImageGraphic().getFullBounds().getWidth(), 0.0);
        this.rightGun.setControlBackgroundColor(PinkGunDetails.backgroundColor);
        this.rightGun.translateOnGunControls(10, 5);
        this.leftGun.addListener(new MandelGun.Listener(){

            public void wavelengthChanged() {
                MandelGunSet.this.updateWavelengths();
            }

            public void intensityChanged() {
            }
        });
        this.rightGun.addListener(new MandelGun.Listener(){

            public void wavelengthChanged() {
                MandelGunSet.this.updateWavelengths();
            }

            public void intensityChanged() {
            }
        });
        this.getOnGunGraphic().setVisible(false);
        this.getOnGunGraphic().setPickable(false);
        this.getOnGunGraphic().setChildrenPickable(false);
        this.getGunImageGraphic().setVisible(false);
        this.getGunImageGraphic().setPickable(false);
        this.getGunImageGraphic().setChildrenPickable(false);
        this.addChild(this.leftGun);
        this.addChild(this.rightGun);
        this.layoutChildren();
        this.setOnOffTextVisible(false);
    }

    private void updateWavelengths() {
        this.photonMandelBeam.setLeftMomentum(this.leftGun.getMomentum());
        this.photonMandelBeam.setRightMomentum(this.rightGun.getMomentum());
    }

    protected void layoutChildren() {
        super.layoutChildren();
        Point point = this.getGunLocation();
        double d = this.getGunOffsetDx();
        if (this.leftGun != null && this.rightGun != null) {
            double d2 = 5.0;
            this.leftGun.setOffset(new Point2D.Double(((Point2D)point).getX() - d, ((Point2D)point).getY() - d2));
            this.rightGun.setOffset(new Point2D.Double(((Point2D)point).getX() + d, ((Point2D)point).getY() - d2));
        }
    }

    private double getGunOffsetDx() {
        double d = this.getSchrodingerPanel().getWavefunctionGraphic().getGlobalFullBounds().getWidth();
        return d / 2.0 - d * DoublePhotonWave.getFractionalInset();
    }

    public void setBeamParameters(MandelModule.BeamParam beamParam, MandelModule.BeamParam beamParam2) {
        this.photonMandelBeam.setBeamParameters(beamParam, beamParam2);
    }

    protected ImagePComboBox initComboBox() {
        this.photon = new Photon(this, QWIResources.getString("particles.photons"), "quantum-wave-interference/images/photon-thumb.png");
        this.photonMandelBeam = new PhotonMandelBeam(this, this.photon);
        ImageComboBox.Item[] itemArray = new IntensityBeam[]{this.photonMandelBeam};
        this.setBeams((IntensityBeam[])itemArray);
        final ImagePComboBox imagePComboBox = new ImagePComboBox(itemArray);
        imagePComboBox.addItemListener(new ItemListener((IntensityBeam[])itemArray){
            final /* synthetic */ IntensityBeam[] val$beams;
            {
                this.val$beams = intensityBeamArray;
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                int n = imagePComboBox.getSelectedIndex();
                MandelGunSet.this.setupObject(this.val$beams[n]);
            }
        });
        imagePComboBox.setVisible(false);
        return imagePComboBox;
    }

    public MandelGun getLeftGun() {
        return this.leftGun;
    }

    public MandelGun getRightGun() {
        return this.rightGun;
    }
}

