/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.intensity;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.ClearButton;
import edu.colorado.phet.quantumwaveinterference.controls.ExpandableDoubleSlitPanel;
import edu.colorado.phet.quantumwaveinterference.controls.IVisualizationPanel;
import edu.colorado.phet.quantumwaveinterference.controls.ParticleVisualizationPanel;
import edu.colorado.phet.quantumwaveinterference.controls.PhotonVisualizationPanel;
import edu.colorado.phet.quantumwaveinterference.controls.PotentialPanel;
import edu.colorado.phet.quantumwaveinterference.controls.QWIControlPanel;
import edu.colorado.phet.quantumwaveinterference.controls.ResetButton;
import edu.colorado.phet.quantumwaveinterference.controls.VisualizationPanelContainer;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityModule;
import edu.colorado.phet.quantumwaveinterference.util.ComponentCenterer;

public class IntensityControlPanel
extends QWIControlPanel {
    private IntensityModule intensityModule;
    private ParticleVisualizationPanel particleVisualizationPanel;
    private VisualizationPanelContainer visualizationPanel;
    private IVisualizationPanel photonVisualizationPanel;

    public IntensityControlPanel(final IntensityModule intensityModule) {
        super(intensityModule);
        this.intensityModule = intensityModule;
        this.addSeparator();
        this.addSpacer();
        ResetButton resetButton = new ResetButton(intensityModule);
        this.getContentPanel().setAnchor(10);
        this.addControl(resetButton);
        this.addControl(new ClearButton(intensityModule.getSchrodingerPanel()));
        this.getContentPanel().setAnchor(17);
        this.addSpacer();
        this.addSeparator();
        this.addSpacer();
        this.photonVisualizationPanel = new PhotonVisualizationPanel(this.getSchrodingerPanel());
        this.particleVisualizationPanel = new ParticleVisualizationPanel(this.getSchrodingerPanel());
        intensityModule.addListener(new IntensityModule.Adapter(){

            public void detectorsChanged() {
                if (intensityModule.isLeftDetectorEnabled() || intensityModule.isRightDetectorEnabled()) {
                    IntensityControlPanel.this.particleVisualizationPanel.setMagnitudeMode();
                    IntensityControlPanel.this.particleVisualizationPanel.setPhaseColorEnabled(false);
                } else {
                    IntensityControlPanel.this.particleVisualizationPanel.setLastUserSelected();
                    IntensityControlPanel.this.particleVisualizationPanel.setPhaseColorEnabled(true);
                }
            }
        });
        intensityModule.addListener(new QWIModule.Listener(){

            public void deactivated() {
            }

            public void activated() {
            }

            public void beamTypeChanged() {
                IntensityControlPanel.this.updateVisualizationPanel();
            }
        });
        this.visualizationPanel = new VisualizationPanelContainer(this.photonVisualizationPanel, this.particleVisualizationPanel);
        this.addControlFullWidth(this.visualizationPanel);
        new ComponentCenterer(resetButton, super.getContentPanel()).start();
        ExpandableDoubleSlitPanel expandableDoubleSlitPanel = new ExpandableDoubleSlitPanel(intensityModule);
        this.setPreferredWidth(expandableDoubleSlitPanel.getControls().getPreferredSize().width + 10);
        this.addControl(expandableDoubleSlitPanel);
        AdvancedPanel advancedPanel = new AdvancedPanel(QWIResources.getString("controls.barriers.show"), QWIResources.getString("controls.barriers.hide"));
        advancedPanel.addControlFullWidth(new PotentialPanel(this.getModule()));
        this.addControl(advancedPanel);
        this.updateVisualizationPanel();
    }

    private void updateVisualizationPanel() {
        this.visualizationPanel.setPhotonMode(this.isPhotonMode());
    }

    private boolean isPhotonMode() {
        return this.intensityModule.getIntensityPanel().getHighIntensityGun().isPhotonMode();
    }
}

