/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.waves;

import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;

public class FlatDampedWave
implements Wave {
    private Wave wave;
    private double intensity;
    private int x0 = 50;
    private double dxLattice = 7.0;
    private int radiusForMax = 3;

    public FlatDampedWave(Wave wave, double d, int n, double d2) {
        this.wave = wave;
        this.intensity = d;
        this.x0 = n / 2;
        this.dxLattice = d2;
        this.radiusForMax = (int)((double)(3 * n) / 100.0);
    }

    public Complex getValue(int n, int n2, double d) {
        int n3 = n - this.x0;
        double d2 = 1.0;
        if (Math.abs(n3) > this.radiusForMax) {
            double d3 = Math.abs(n3) - this.radiusForMax;
            d2 = Math.exp(-d3 * d3 / 4.0 / this.dxLattice / this.dxLattice);
        }
        return this.wave.getValue(n, n2, d).times(d2 * this.intensity);
    }
}

