/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.math;

public class Complex {
    public double real;
    public double imag;

    public Complex(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(Complex complex) {
        this(complex.real, complex.imag);
    }

    public void zero() {
        this.real = 0.0;
        this.imag = 0.0;
    }

    public String toString() {
        return "[" + this.real + "," + this.imag + "]";
    }

    public Complex times(double d) {
        return new Complex(this.real * d, this.imag * d);
    }

    public Complex plus(Complex complex) {
        return new Complex(this.real + complex.real, this.imag + complex.imag);
    }

    public Complex times(Complex complex) {
        return new Complex(complex.real * this.real - complex.imag * this.imag, complex.real * this.imag + complex.imag * this.real);
    }

    public Complex minus(Complex complex) {
        return new Complex(this.real - complex.real, this.imag - complex.imag);
    }

    public Complex divideBy(Complex complex) {
        double d = complex.real * complex.real + complex.imag * complex.imag;
        double d2 = this.real * complex.real + this.imag * complex.imag;
        double d3 = this.imag * complex.real - this.real * complex.imag;
        return new Complex(d2 / d, d3 / d);
    }

    public double abs() {
        return Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    public double getReal() {
        return this.real;
    }

    public double getImaginary() {
        return this.imag;
    }

    public boolean equals(Object object) {
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            return this.real == complex.real && this.imag == complex.imag;
        }
        return false;
    }

    public void setValue(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    public Complex complexConjugate() {
        return new Complex(this.real, -this.imag);
    }

    public void scale(double d) {
        this.real *= d;
        this.imag *= d;
    }

    public Complex copy() {
        return new Complex(this.real, this.imag);
    }

    public void setToSum(Complex complex, Complex complex2) {
        this.real = complex.real + complex2.real;
        this.imag = complex.imag + complex2.imag;
    }

    public void setToProduct(Complex complex, Complex complex2) {
        this.real = complex.real * complex2.real - complex.imag * complex2.imag;
        this.imag = complex.real * complex2.imag + complex.imag * complex2.real;
    }

    public void setToSum(Complex complex, Complex complex2, Complex complex3) {
        this.real = complex.real + complex2.real + complex3.real;
        this.imag = complex.imag + complex2.imag + complex3.imag;
    }

    public static Complex exponentiateImaginary(double d) {
        return new Complex(Math.cos(d), Math.sin(d));
    }

    public void add(Complex complex) {
        this.add(complex.real, complex.imag);
    }

    public double getComplexPhase() {
        return Math.atan2(this.imag, this.real);
    }

    public void add(double d, double d2) {
        this.real += d;
        this.imag += d2;
    }
}

