/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.ComplexColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.GrayscaleColorMap;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.SimpleWavefunctionGraphic;
import javax.swing.JFrame;

public class WaveDebugger {
    private Wavefunction wavefunction;
    private JFrame frame;
    private PhetPCanvas phetPCanvas;
    private SimpleWavefunctionGraphic simpleWavefunctionGraphic;

    public WaveDebugger(String string, Wavefunction wavefunction, int n, int n2) {
        this.wavefunction = wavefunction;
        this.frame = new JFrame(string);
        this.phetPCanvas = new PhetPCanvas();
        this.frame.setContentPane(this.phetPCanvas);
        this.simpleWavefunctionGraphic = new SimpleWavefunctionGraphic(wavefunction, n, n2);
        this.simpleWavefunctionGraphic.setComplexColorMap(new GrayscaleColorMap.Real());
        this.phetPCanvas.addScreenChild(this.simpleWavefunctionGraphic);
        this.frame.setSize(600, 600);
        this.frame.setDefaultCloseOperation(3);
    }

    public void setComplexColorMap(ComplexColorMap complexColorMap) {
        this.simpleWavefunctionGraphic.setComplexColorMap(complexColorMap);
        this.update();
    }

    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
    }

    public void update() {
        this.simpleWavefunctionGraphic.update();
    }
}

