/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.model.CylinderSource;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.waves.FlatDampedWave;
import edu.colorado.phet.quantumwaveinterference.model.waves.PlaneWave;
import java.awt.Rectangle;

public class PhotonWave {
    private QWIModule module;
    private QWIModel QWIModel;
    private CylinderSource waveSource;
    private double momentum = 0.6283185307179586;
    private double dPhase = 0.5235987755982988;
    private double waveMagnitude = 0.075;
    private double phase = 0.0;
    private double intensity = 0.0;
    private double intensityScale = 0.75;
    private int waveSourceHeight = 2;
    private ModelElement phaseUpdate;
    private QWIModel.Adapter waveSourceBoundaryConditionSetter;

    public PhotonWave(QWIModule qWIModule, QWIModel qWIModel) {
        this.module = qWIModule;
        this.QWIModel = qWIModel;
        this.waveSource = new CylinderSource(this.createRectRegionForCylinder(), this.createWave(this.phase));
        this.phaseUpdate = new ModelElement(){

            public void stepInTime(double d) {
                PhotonWave.this.updatePhase();
            }
        };
        this.waveSourceBoundaryConditionSetter = new QWIModel.Adapter(){

            public void beforeTimeStep(QWIModel qWIModel) {
                PhotonWave.this.initializeEntrantWave();
            }
        };
        qWIModel.addListener(new QWIModel.Adapter(){

            public void sizeChanged() {
                PhotonWave.this.updateWaveSource();
            }
        });
    }

    protected void initializeEntrantWave() {
        this.waveSource.initializeEntrantWave(this.QWIModel.getWaveModel(), this.QWIModel.getSimulationTime());
        this.waveSource.initializeEntrantWave(this.QWIModel.getSourceWaveModel(), this.QWIModel.getSimulationTime());
    }

    public void setMomentum(double d) {
        this.momentum = d;
        this.dPhase = Math.abs(d);
        this.updateWaveSource();
    }

    public void setOff() {
        this.clearElements();
    }

    private void clearElements() {
        while (this.getDiscreteModel().containsListener(this.waveSourceBoundaryConditionSetter)) {
            this.getDiscreteModel().removeListener(this.waveSourceBoundaryConditionSetter);
        }
        while (this.module.getModel().containsModelElement(this.phaseUpdate)) {
            this.module.getModel().removeModelElement(this.phaseUpdate);
        }
    }

    public void setOn() {
        this.clearElements();
        this.waveSource.setRegion(this.createRectRegionForCylinder());
        this.getDiscreteModel().addListener(this.waveSourceBoundaryConditionSetter);
        this.module.getModel().addModelElement(this.phaseUpdate);
    }

    private void updatePhase() {
        this.phase += this.dPhase;
        this.updateWaveSource();
    }

    protected void updateWaveSource() {
        this.waveSource.setWave(this.createWave(this.phase));
    }

    protected Wave createWave(double d) {
        PlaneWave planeWave = new PlaneWave(this.momentum, this.getDiscreteModel().getGridWidth());
        planeWave.setPhase(d);
        planeWave.setMagnitude(this.waveMagnitude);
        double d2 = (double)(7 * this.getDiscreteModel().getGridWidth()) / 100.0 * 1.3;
        return new FlatDampedWave(planeWave, this.intensity * this.intensityScale, this.getDiscreteModel().getGridWidth(), d2);
    }

    protected Rectangle createRectRegionForCylinder() {
        return new Rectangle(0, this.getWavefunction().getHeight() - this.waveSourceHeight, this.getWavefunction().getWidth(), this.waveSourceHeight);
    }

    private Wavefunction getWavefunction() {
        return this.getDiscreteModel().getWavefunction();
    }

    public QWIModel getDiscreteModel() {
        return this.QWIModel;
    }

    public void setIntensity(double d) {
        this.intensity = d;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public double getMagnitude() {
        return this.waveMagnitude;
    }

    public double getIntensityScale() {
        return this.intensityScale;
    }

    public double getPhase() {
        return this.phase;
    }
}

