/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;

public class Damping
extends QWIModel.Adapter {
    private double[] damp = new double[]{0.999, 0.995, 0.99, 0.975, 0.95, 0.925, 0.9, 0.85, 0.7, 0.3};

    public void finishedTimeStep(QWIModel qWIModel) {
        this.damp(qWIModel.getWavefunction());
    }

    public void damp(Wavefunction wavefunction) {
        this.dampLeft(wavefunction);
        this.dampRight(wavefunction);
        this.dampTop(wavefunction);
        this.dampBottom(wavefunction);
    }

    private void dampBottom(Wavefunction wavefunction) {
        for (int i = 0; i < this.damp.length; ++i) {
            double d = this.getScaleFactor(i);
            int n = wavefunction.getHeight() - this.damp.length + i;
            for (int j = 0; j < wavefunction.getWidth(); ++j) {
                wavefunction.valueAt(j, n).scale(d);
            }
        }
    }

    private void dampTop(Wavefunction wavefunction) {
        for (int i = 0; i < this.damp.length; ++i) {
            double d = this.getScaleFactor(i);
            int n = this.damp.length - i - 1;
            for (int j = 0; j < wavefunction.getWidth(); ++j) {
                wavefunction.valueAt(j, n).scale(d);
            }
        }
    }

    private void dampRight(Wavefunction wavefunction) {
        for (int i = 0; i < this.damp.length; ++i) {
            double d = this.getScaleFactor(i);
            int n = wavefunction.getWidth() - this.damp.length + i;
            for (int j = 0; j < wavefunction.getHeight(); ++j) {
                wavefunction.valueAt(n, j).scale(d);
            }
        }
    }

    private void dampLeft(Wavefunction wavefunction) {
        for (int i = 0; i < this.damp.length; ++i) {
            double d = this.getScaleFactor(i);
            int n = this.damp.length - i - 1;
            for (int j = 0; j < wavefunction.getHeight(); ++j) {
                wavefunction.valueAt(n, j).scale(d);
            }
        }
    }

    private double getScaleFactor(int n) {
        return this.damp[n];
    }
}

