/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.davissongermer.ConstrainedSliderControl;
import edu.colorado.phet.quantumwaveinterference.davissongermer.CoordinateFrame;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGModel;
import java.text.DecimalFormat;

public class SpacingControl
extends ConstrainedSliderControl {
    private DGModel dgModel;

    private static int getNumSliderValues(CoordinateFrame coordinateFrame) {
        return SpacingControl.getNumSliderValues(coordinateFrame.getMin(), coordinateFrame.getMax());
    }

    public double getModelValue() {
        return this.dgModel.getFractionalSpacing();
    }

    public void setModelValue(double d) {
        this.dgModel.setFractionalSpacing(d);
    }

    private static int getNumSliderValues(double d, double d2) {
        double d3 = 0.1;
        return (int)(Math.round((d2 - d) / d3) + 1L);
    }

    public SpacingControl(DGModel dGModel) {
        this.dgModel = dGModel;
        this.init(QWIResources.getString("atom.separation.d"), new DecimalFormat("0.0"), dGModel.getSpacingModelFrame(), dGModel.getSpacingViewFrame(), new CoordinateFrame(0.0, SpacingControl.getNumSliderValues(dGModel.getSpacingViewFrame()) - 1));
        dGModel.addListener(new DGModel.Listener(){

            public void potentialChanged() {
                SpacingControl.this.update();
            }
        });
    }
}

