/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.quantumwaveinterference.QWIOptionsMenu;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.davissongermer.AtomPotential;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGControlPanel;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGGun;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGModel;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGOptionsMenu;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGParticle;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGPlotFrame;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGPlotPanel;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGSchrodingerPanel;
import edu.colorado.phet.quantumwaveinterference.davissongermer.Protractor;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.potentials.RectangularPotential;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityBeamPanel;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityModule;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.ImagePotentialGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.RectangularPotentialGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.WavefunctionGraphic;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class DGModule
extends IntensityModule {
    private Protractor protractor;
    private DGModel dgModel = new DGModel(this.getQWIModel());
    private DGPlotFrame dgPlotFrame = new DGPlotFrame((Frame)this.getPhetFrame(), this);

    public DGModule(PhetApplication phetApplication, IClock iClock) {
        super(QWIResources.getString("davisson-germer.name"), phetApplication, iClock);
        this.dgModel.addListener(new DGModel.Listener(){

            public void potentialChanged() {
                DGModule.this.updatePotentialGraphics();
            }
        });
        DGControlPanel dGControlPanel = new DGControlPanel(this);
        this.setControlPanel(dGControlPanel);
        this.setupProtractor();
        this.getSchrodingerPanel().getSchrodingerScreenNode().getDetectorSheetPNode().setVisible(false);
        DGParticle dGParticle = this.getDGParticle();
        dGParticle.addMomentumChangeListerner(new AbstractGunNode.MomentumChangeListener(){

            public void momentumChanged(double d) {
                DGModule.this.clearWave();
            }
        });
        this.dgModel.addListener(new DGModel.Listener(){

            public void potentialChanged() {
                DGModule.this.updateProtractor();
            }
        });
        this.getQWIModel().addListener(new QWIModel.Adapter(){

            public void sizeChanged() {
                DGModule.this.updateProtractor();
            }
        });
        this.updateProtractor();
        this.getSchrodingerPanel().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DGModule.this.updateProtractor();
            }
        });
        this.getSchrodingerPanel().getWavefunctionGraphic().addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DGModule.this.updateProtractor();
            }
        });
        this.getQWIModel().setBarrierAbsorptive(false);
        this.updatePotentialGraphics();
    }

    private void updateProtractor() {
        WavefunctionGraphic wavefunctionGraphic = this.getSchrodingerPanel().getWavefunctionGraphic();
        Point point = this.dgModel.getCenterAtomPoint();
        double d = 0.0;
        double d2 = 0.0;
        if (this.dgModel.getConcreteAtomLattice().getPotentials().length > 0) {
            d = this.dgModel.getConcreteAtomLattice().getPotentials()[0].getDiameter() % 2 == 1 ? 0.5 : 0.0;
            d2 = this.dgModel.getConcreteAtomLattice().getPotentials()[0].getDiameter() % 2 == 1 ? 0.5 : 0.0;
        }
        this.protractor.setOffset(wavefunctionGraphic.getFullBounds().getX() + (double)wavefunctionGraphic.getColorGrid().getCellWidth() * ((double)point.x + d), wavefunctionGraphic.getFullBounds().getY() + (double)wavefunctionGraphic.getColorGrid().getCellHeight() * ((double)point.y + d2));
    }

    private DGParticle getDGParticle() {
        AbstractGunNode abstractGunNode = this.getSchrodingerPanel().getSchrodingerScreenNode().getGunGraphic();
        if (abstractGunNode instanceof DGGun) {
            DGGun dGGun = (DGGun)abstractGunNode;
            return dGGun.getDgParticle();
        }
        return null;
    }

    private void updatePotentialGraphics() {
        this.getSchrodingerPanel().clearPotential();
        AtomPotential[] atomPotentialArray = this.dgModel.getConcreteAtomLattice().getPotentials();
        for (int i = 0; i < atomPotentialArray.length; ++i) {
            AtomPotential atomPotential = atomPotentialArray[i];
            this.addAtomPotentialGraphic(atomPotential);
        }
    }

    public void addAtomPotentialGraphic(AtomPotential atomPotential) {
        int n = 0;
        int n2 = 0;
        if (atomPotential.getDiameter() % 2 == 1) {
            n = 1;
            n2 = 1;
        }
        RectangularPotential rectangularPotential = new RectangularPotential(this.getQWIModel(), (int)(atomPotential.getCenter().getX() - (double)atomPotential.getDiameter() / 2.0) + n, (int)(atomPotential.getCenter().getY() - (double)atomPotential.getDiameter() / 2.0) + n2, atomPotential.getDiameter(), atomPotential.getDiameter());
        rectangularPotential.setPotential(1.7976931348623156E306);
        RectangularPotentialGraphic rectangularPotentialGraphic = this.createPotentialGraphic(rectangularPotential);
        this.getSchrodingerPanel().addRectangularPotentialGraphic(rectangularPotentialGraphic);
    }

    protected RectangularPotentialGraphic createPotentialGraphic(RectangularPotential rectangularPotential) {
        return new ImagePotentialGraphic(this.getSchrodingerPanel(), rectangularPotential);
    }

    protected IntensityBeamPanel createIntensityPanel() {
        return new DGSchrodingerPanel(this);
    }

    private void setupProtractor() {
        this.protractor = new Protractor();
        this.protractor.setLeftLegPickable(false);
        this.protractor.setReadoutGraphicPickable(false);
        this.protractor.addListener(new Protractor.Listener(){

            public void angleChanged(Protractor protractor) {
                DGModule.this.getPlotPanel().setIndicatorAngle(protractor.getDegreesUnsigned());
            }

            public void visibilityChanged(Protractor protractor) {
                DGModule.this.getPlotPanel().setIndicatorVisible(protractor.getVisible());
            }
        });
        this.getSchrodingerPanel().getSchrodingerScreenNode().addChild(this.protractor);
        this.setProtractorVisible(false);
        this.dgModel.addListener(new DGModel.Listener(){

            public void potentialChanged() {
                DGModule.this.updateProtractorCenter();
            }
        });
        this.updateProtractorCenter();
    }

    private void updateProtractorCenter() {
        this.updateProtractor();
    }

    public void setProtractorVisible(boolean bl) {
        this.protractor.setVisible(bl);
    }

    public void clearWave() {
        this.getQWIModel().clearWavefunction();
    }

    public DGModel getDGModel() {
        return this.dgModel;
    }

    public DGPlotFrame getPlotFrame() {
        return this.dgPlotFrame;
    }

    public DGPlotPanel getPlotPanel() {
        return this.dgPlotFrame.getDgPlotPanel();
    }

    public boolean isAtomShapeCircular() {
        return this.dgModel.isAtomShapeCircular();
    }

    public boolean isAtomShapeSquare() {
        return this.dgModel.isAtomShapeSquare();
    }

    public void setAtomShapeCircular() {
        this.dgModel.setAtomShapeCircular();
    }

    public void setAtomShapeSquare() {
        this.dgModel.setAtomShapeSquare();
    }

    public DGSchrodingerPanel getDGSchrodingerPanel() {
        return (DGSchrodingerPanel)this.getSchrodingerPanel();
    }

    protected QWIOptionsMenu createOptionsMenu() {
        return new DGOptionsMenu(this);
    }

    public double getVelocityRealUnits() {
        return this.getDGParticle().getVelocity() * 100.0;
    }

    public double getSpacing() {
        return this.dgModel.getFractionalSpacing() * (double)this.dgModel.getWavefunction().getWidth() / 10.0;
    }
}

