/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.InitialConditionPanel;
import edu.colorado.phet.quantumwaveinterference.controls.IntensityScreenPanel;
import edu.colorado.phet.quantumwaveinterference.controls.RulerPanel;
import edu.colorado.phet.quantumwaveinterference.controls.StopwatchCheckBox;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.WaveSetup;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QWIControlPanel
extends ControlPanel {
    private QWIModule module;
    private InitialConditionPanel initialConditionPanel;
    private AdvancedPanel advancedPanel;

    public QWIControlPanel(QWIModule qWIModule) {
        this.module = qWIModule;
        this.getContentPanel().setAnchor(17);
        this.initialConditionPanel = this.createInitialConditionPanel();
        AdvancedPanel advancedPanel = new AdvancedPanel(QWIResources.getString("show"), QWIResources.getString("hide"));
        advancedPanel.addControlFullWidth(this.initialConditionPanel);
        advancedPanel.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("initial.conditions")));
        advancedPanel.addListener(new AdvancedPanel.Listener(){

            public void advancedPanelHidden(AdvancedPanel advancedPanel) {
                JFrame jFrame = (JFrame)SwingUtilities.getWindowAncestor(QWIControlPanel.this);
                jFrame.invalidate();
                jFrame.validate();
                jFrame.repaint();
            }

            public void advancedPanelShown(AdvancedPanel advancedPanel) {
            }
        });
        JButton jButton = new JButton(QWIResources.getString("fire.particle"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QWIControlPanel.this.fireParticle();
            }
        });
        try {
            this.addMeasuringTools();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.advancedPanel = new AdvancedPanel(QWIResources.getString("advanced"), QWIResources.getString("hide.advanced"));
        IntensityScreenPanel intensityScreenPanel = new IntensityScreenPanel(this);
        AdvancedPanel advancedPanel2 = new AdvancedPanel(QWIResources.getString("screen1"), QWIResources.getString("screen2"));
        advancedPanel2.addControl(intensityScreenPanel);
        this.advancedPanel.addControlFullWidth(advancedPanel2);
        VerticalLayoutPanel verticalLayoutPanel = this.createSimulationPanel(qWIModule);
        AdvancedPanel advancedPanel3 = new AdvancedPanel(QWIResources.getString("simulation"), QWIResources.getString("hide.simulation"));
        advancedPanel3.addControlFullWidth(verticalLayoutPanel);
        this.advancedPanel.addControlFullWidth(advancedPanel3);
    }

    protected void addSpacer() {
        this.addBox(10, 10);
    }

    protected void addBox(int n, int n2) {
        Box box = new Box(0);
        box.setPreferredSize(new Dimension(n, n2));
        box.setSize(n, n2);
        this.addControl(box);
    }

    protected void setPreferredWidth(int n) {
        this.setPreferredSize(new Dimension(n, this.getPreferredSize().height));
        this.setSize(this.getPreferredSize());
        Box box = new Box(0);
        box.setPreferredSize(new Dimension(n - 2, 2));
        box.setSize(n - 2, 2);
        this.addControlFullWidth(box);
    }

    protected void addMeasuringTools() throws IOException {
        this.getContentPanel().setFillNone();
        this.addControl(new RulerPanel(this.getSchrodingerPanel()));
        this.addControl(new StopwatchCheckBox(this.getSchrodingerPanel()));
    }

    private WaveSetup getWaveSetup() {
        return this.initialConditionPanel.getWaveSetup();
    }

    private InitialConditionPanel createInitialConditionPanel() {
        return new InitialConditionPanel(this);
    }

    private VerticalLayoutPanel createSimulationPanel(final QWIModule qWIModule) {
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("simulation1")));
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.getDiscreteModel().getGridWidth(), 1, 1000, 10));
        jSpinner.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("menus.resolution")));
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)jSpinner.getValue();
                qWIModule.setGridSize(n, n);
            }
        });
        verticalLayoutPanel.addFullWidth(jSpinner);
        final JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(0.8, 0.0, 2.0, 0.1));
        jSpinner2.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("dt")));
        jSpinner2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = ((Number)jSpinner2.getValue()).doubleValue();
                QWIControlPanel.this.getDiscreteModel().setDeltaTime(d);
            }
        });
        verticalLayoutPanel.addFullWidth(jSpinner2);
        return verticalLayoutPanel;
    }

    public QWIPanel getSchrodingerPanel() {
        return this.module.getSchrodingerPanel();
    }

    public void fireParticle() {
        WaveSetup waveSetup = this.getWaveSetup();
        this.module.fireParticle(waveSetup);
    }

    public QWIModel getDiscreteModel() {
        return this.module.getQWIModel();
    }

    public QWIModule getModule() {
        return this.module;
    }

    public AdvancedPanel getAdvancedPanel() {
        return this.advancedPanel;
    }
}

