/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.QWIControlPanel;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.WaveSetup;
import edu.colorado.phet.quantumwaveinterference.model.waves.GaussianWave2D;
import java.awt.Point;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InitialConditionPanel
extends VerticalLayoutPanel {
    private ModelSlider xSlider;
    private ModelSlider ySlider;
    private ModelSlider pxSlider;
    private ModelSlider pySlider;
    private ModelSlider dxSlider;
    private QWIControlPanel qwiControlPanel;

    public InitialConditionPanel(QWIControlPanel qWIControlPanel) {
        this.qwiControlPanel = qWIControlPanel;
        this.xSlider = new ModelSlider(QWIResources.getString("x0"), QWIResources.getString("1.l"), 0.0, 1.0, 0.5);
        this.ySlider = new ModelSlider(QWIResources.getString("y0"), QWIResources.getString("1.l"), 0.0, 1.0, 0.75);
        this.pxSlider = new ModelSlider(QWIResources.getString("momentum.x0"), "", -1.5, 1.5, 0.0);
        this.pySlider = new ModelSlider(QWIResources.getString("momentum.y0"), "", -1.5, 1.5, -0.8);
        this.dxSlider = new ModelSlider(QWIResources.getString("size0"), "", 0.0, 0.25, 0.04);
        this.pxSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = Math.PI * 2 / InitialConditionPanel.this.pxSlider.getValue();
                System.out.println("lambda = " + d);
            }
        });
        this.add(this.xSlider);
        this.add(this.ySlider);
        this.add(this.pxSlider);
        this.add(this.pySlider);
        this.add(this.dxSlider);
    }

    private double getStartDxLattice() {
        double d = this.dxSlider.getValue() * (double)this.getDiscreteModel().getGridWidth();
        System.out.println("dxLattice = " + d);
        return d;
    }

    private double getStartPy() {
        return this.pySlider.getValue();
    }

    private double getStartPx() {
        return this.pxSlider.getValue();
    }

    private double getStartY() {
        return this.ySlider.getValue() * (double)this.getDiscreteModel().getGridHeight();
    }

    private QWIModel getDiscreteModel() {
        return this.qwiControlPanel.getDiscreteModel();
    }

    private double getStartX() {
        return this.xSlider.getValue() * (double)this.getDiscreteModel().getGridWidth();
    }

    public WaveSetup getWaveSetup() {
        double d = this.getStartX();
        double d2 = this.getStartY();
        double d3 = this.getStartPx();
        double d4 = this.getStartPy();
        double d5 = this.getStartDxLattice();
        return new GaussianWave2D(new Point((int)d, (int)d2), new Vector2D(d3, d4), d5, this.getHBar());
    }

    private double getHBar() {
        return 1.0;
    }
}

