/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.InverseSlitsCheckbox;
import edu.colorado.phet.quantumwaveinterference.controls.SlitDetectorPanel;
import edu.colorado.phet.quantumwaveinterference.model.FractionalDoubleSlit;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.potentials.HorizontalDoubleSlit;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityModule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoubleSlitControlPanel
extends VerticalLayoutPanel {
    private QWIModel QWIModel;
    private HorizontalDoubleSlit horizontalDoubleSlit;
    private JComponent slitSize;
    private JComponent slitSeparation;
    private JComponent verticalPosition;
    private SlitDetectorPanel slitDetectorPanel;
    private QWIModule module;
    private FractionalDoubleSlit fractionalSlit;

    public DoubleSlitControlPanel(QWIModel qWIModel, QWIModule qWIModule) {
        this.QWIModel = qWIModel;
        this.module = qWIModule;
        this.horizontalDoubleSlit = qWIModel.getDoubleSlitPotential();
        this.fractionalSlit = qWIModel.getFractionalDoubleSlit();
        this.verticalPosition = this.createComponent(QWIResources.getString("controls.slits.vertical-position"), new Setter(){
            double insetY = 0.16666666666666666;

            public void valueChanged(double d) {
                DoubleSlitControlPanel.this.fractionalSlit.setY(d);
            }

            public double getValue() {
                return DoubleSlitControlPanel.this.fractionalSlit.getY();
            }

            public double getMin() {
                return 0.0 + this.insetY;
            }

            public double getMax() {
                return 1.0 - this.insetY;
            }

            public int getViewValue(Function function) {
                return (int)function.evaluate(this.getValue());
            }
        });
        this.slitSize = this.createComponent(QWIResources.getString("controls.slits.width"), new Setter(){

            public void valueChanged(double d) {
                DoubleSlitControlPanel.this.fractionalSlit.setSlitSize(d);
            }

            public double getValue() {
                return DoubleSlitControlPanel.this.fractionalSlit.getSlitSize();
            }

            public double getMin() {
                return 0.08888888888888889;
            }

            public double getMax() {
                return 0.4166666666666667;
            }

            public int getViewValue(Function function) {
                return (int)function.evaluate(this.getValue());
            }
        });
        this.slitSeparation = this.createComponent(QWIResources.getString("controls.slits.separation"), new Setter(){

            public void valueChanged(double d) {
                DoubleSlitControlPanel.this.fractionalSlit.setSlitSeparation(d);
            }

            public double getValue() {
                return DoubleSlitControlPanel.this.fractionalSlit.getSlitSeparation();
            }

            public double getMin() {
                return 0.13333333333333333;
            }

            public double getMax() {
                return 0.5;
            }

            public int getViewValue(Function function) {
                return (int)function.evaluate(this.getValue());
            }
        });
        final JCheckBox jCheckBox = new JCheckBox(QWIResources.getString("controls.slits.absorbing-barriers"), this.getDiscreteModel().isBarrierAbsorptive());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DoubleSlitControlPanel.this.getDiscreteModel().setBarrierAbsorptive(jCheckBox.isSelected());
            }
        });
        this.add(jCheckBox);
        this.add(this.slitSize);
        this.add(this.slitSeparation);
        this.add(this.verticalPosition);
        if (qWIModule instanceof IntensityModule) {
            this.slitDetectorPanel = new SlitDetectorPanel((IntensityModule)qWIModule);
            this.addFullWidth(this.slitDetectorPanel);
        }
        this.setControlsEnabled(true);
        this.addFullWidth(new InverseSlitsCheckbox(qWIModule.getSchrodingerPanel()));
    }

    private void setControlsEnabled(boolean bl) {
        this.slitSize.setEnabled(bl);
        this.slitSeparation.setEnabled(bl);
        this.verticalPosition.setEnabled(bl);
    }

    private JComponent createComponent(String string, final Setter setter) {
        final Function.LinearFunction linearFunction = new Function.LinearFunction(setter.getMin(), setter.getMax(), 0.0, 100.0);
        final Function.LinearFunction linearFunction2 = new Function.LinearFunction(0.0, 100.0, setter.getMin(), setter.getMax());
        int n = setter.getViewValue(linearFunction);
        final JSlider jSlider = new JSlider(0, 100, n);
        jSlider.setBorder(BorderFactory.createTitledBorder(string));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                setter.valueChanged(linearFunction2.evaluate(jSlider.getValue()));
            }
        });
        this.module.getClock().addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                jSlider.setValue(setter.getViewValue(linearFunction));
            }
        });
        return jSlider;
    }

    private QWIModel getDiscreteModel() {
        return this.QWIModel;
    }

    private static interface Setter {
        public void valueChanged(double var1);

        public double getMin();

        public double getMax();

        public int getViewValue(Function var1);
    }
}

