/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference;

import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.PropagatorPanel;
import edu.colorado.phet.quantumwaveinterference.controls.ResolutionControl;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.phetcommon.UIController;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class QWIOptionsMenu
extends JMenu {
    private QWIModule qwiModule;
    private JDialog dialog;
    private JDialog propagatorControlFrame;
    private boolean debug = false;
    private JCheckBoxMenuItem expectationValueXItem;
    private JCheckBoxMenuItem expectationValueYItem;

    public QWIOptionsMenu(final QWIModule qWIModule) {
        super(QWIResources.getString("menus.options"));
        JMenuItem jMenuItem;
        this.setMnemonic('o');
        this.qwiModule = qWIModule;
        this.expectationValueXItem = new JCheckBoxMenuItem(QWIResources.getString("menus.show-expectation-x"));
        this.expectationValueXItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QWIOptionsMenu.this.getSchrodingerPanel().getWavefunctionGraphic().setDisplayXExpectation(QWIOptionsMenu.this.expectationValueXItem.isSelected());
            }
        });
        this.add(this.expectationValueXItem);
        this.expectationValueYItem = new JCheckBoxMenuItem(QWIResources.getString("menus.show-expectation-y"));
        this.expectationValueYItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QWIOptionsMenu.this.getSchrodingerPanel().getWavefunctionGraphic().setDisplayYExpectation(QWIOptionsMenu.this.expectationValueYItem.isSelected());
            }
        });
        this.add(this.expectationValueYItem);
        JMenuItem jMenuItem2 = new JMenuItem(QWIResources.getString("menus.resolution"));
        final ResolutionControl resolutionControl = new ResolutionControl(qWIModule);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (QWIOptionsMenu.this.dialog == null) {
                    QWIOptionsMenu.this.dialog = new JDialog(qWIModule.getPhetFrame());
                    QWIOptionsMenu.this.dialog.setContentPane(resolutionControl.getControls());
                    QWIOptionsMenu.this.dialog.pack();
                    qWIModule.addListener(new QWIModule.Listener(){

                        public void deactivated() {
                            qWIModule.removeListener(this);
                            QWIOptionsMenu.this.dialog.setVisible(false);
                            QWIOptionsMenu.this.dialog.dispose();
                        }

                        public void activated() {
                        }

                        public void beamTypeChanged() {
                        }
                    });
                }
                QWIOptionsMenu.this.dialog.show();
            }
        });
        this.add(jMenuItem2);
        if (this.debug) {
            jMenuItem = new JMenuItem(QWIResources.getString("print.model.parameter"));
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    QWIOptionsMenu.this.printModelParameters();
                }
            });
            this.add(jMenuItem);
        }
        this.addSeparator();
        jMenuItem = new JMenuItem(QWIResources.getString("propagators"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (QWIOptionsMenu.this.propagatorControlFrame == null) {
                    QWIOptionsMenu.this.propagatorControlFrame = new JDialog((Frame)qWIModule.getPhetFrame(), QWIResources.getString("propagators"));
                    QWIOptionsMenu.this.propagatorControlFrame.setContentPane(new PropagatorPanel(QWIOptionsMenu.this.getDiscreteModel()));
                    QWIOptionsMenu.this.propagatorControlFrame.pack();
                    SwingUtils.centerDialogInParent(QWIOptionsMenu.this.propagatorControlFrame);
                }
                QWIOptionsMenu.this.propagatorControlFrame.setVisible(true);
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem(QWIResources.getString("ui"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIController.showUIController();
            }
        });
        this.add(jMenuItem3);
    }

    private QWIModel getDiscreteModel() {
        return this.qwiModule.getQWIModel();
    }

    private void printModelParameters() {
        Map map = this.qwiModule.getModelParameters();
        String string = this.toText(map);
        PhetOptionPane.showMessageDialog(this, string);
    }

    private String toText(Map map) {
        Iterator iterator = map.keySet().iterator();
        String string = new String();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            string = string + k + " = " + v;
            if (!iterator.hasNext()) continue;
            string = string + System.getProperty("line.separator");
        }
        return string;
    }

    public void removeExpectationValueItems() {
        this.remove(this.expectationValueXItem);
        this.remove(this.expectationValueYItem);
    }

    private QWIPanel getSchrodingerPanel() {
        return this.qwiModule.getSchrodingerPanel();
    }
}

