/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.mediabuttons;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.TimeControlListener;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloTimeControlPanel;

public class PiccoloClockControlPanel
extends PiccoloTimeControlPanel {
    private IClock clock;
    private ClockAdapter clockListener;

    public PiccoloClockControlPanel(final IClock iClock) {
        if (iClock == null) {
            throw new RuntimeException("Cannot have a control panel for a null clock.");
        }
        this.clock = iClock;
        this.addTimeControlListener(new TimeControlListener(){

            public void stepPressed() {
                iClock.stepClockWhilePaused();
            }

            public void playPressed() {
                iClock.start();
            }

            public void pausePressed() {
                iClock.pause();
            }

            public void restartPressed() {
                iClock.resetSimulationTime();
            }

            public void stepBackPressed() {
                iClock.stepClockBackWhilePaused();
            }
        });
        this.clockListener = new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                PiccoloClockControlPanel.this.setPaused(iClock.isPaused());
            }

            public void clockPaused(ClockEvent clockEvent) {
                PiccoloClockControlPanel.this.setPaused(iClock.isPaused());
            }

            public void simulationTimeChanged(ClockEvent clockEvent) {
                PiccoloClockControlPanel.this.setTimeDisplay(iClock.getSimulationTime());
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
            }
        };
        iClock.addClockListener(this.clockListener);
        this.setPaused(iClock.isPaused());
        this.setTimeDisplay(iClock.getSimulationTime());
    }
}

