/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.dischargelamps.DischargeLampsConfig;
import edu.colorado.phet.dischargelamps.quantum.view.PlateGraphic;
import edu.colorado.phet.photoelectric.model.PhotoelectricModel;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;

public class PhotoelectricPlateGraphic
extends PlateGraphic {
    public static int POSITIVE = 0;
    public static int NEGATIVE = 1;
    private static String[] chars = new String[]{"+", "-"};
    private static Color[] colors = new Color[]{Color.red, Color.blue};
    private int polarity;
    private ArrayList chargeIndicatorGraphics = new ArrayList();

    public PhotoelectricPlateGraphic(Component component, double d, PhotoelectricModel photoelectricModel, int n) {
        super(component, d);
        if (n != POSITIVE && n != NEGATIVE) {
            throw new RuntimeException("invalid polarity");
        }
        this.polarity = n;
        photoelectricModel.addChangeListener(new PotentialChangeListener());
    }

    class PotentialChangeListener
    extends PhotoelectricModel.ChangeListenerAdapter {
        PotentialChangeListener() {
        }

        public void voltageChanged(PhotoelectricModel.ChangeEvent changeEvent) {
            int n;
            Color color = null;
            PhotoelectricModel photoelectricModel = changeEvent.getPhotoelectricModel();
            int n2 = 0;
            if (photoelectricModel.getVoltage() > 0.0) {
                n2 = PhotoelectricPlateGraphic.this.polarity;
            } else if (photoelectricModel.getVoltage() < 0.0) {
                n2 = (PhotoelectricPlateGraphic.this.polarity + 1) % chars.length;
            }
            String string = chars[n2];
            color = colors[n2];
            for (n = 0; n < PhotoelectricPlateGraphic.this.chargeIndicatorGraphics.size(); ++n) {
                PhetGraphic phetGraphic = (PhetGraphic)PhotoelectricPlateGraphic.this.chargeIndicatorGraphics.get(n);
                PhotoelectricPlateGraphic.this.removeGraphic(phetGraphic);
            }
            PhotoelectricPlateGraphic.this.chargeIndicatorGraphics.clear();
            n = (int)Math.abs(photoelectricModel.getVoltage() * 10.0);
            double d = (double)(PhotoelectricPlateGraphic.this.getHeight() - 10) / (double)(n + 1);
            for (int i = 0; i < n; ++i) {
                PhetTextGraphic phetTextGraphic = new PhetTextGraphic(PhotoelectricPlateGraphic.this.getComponent(), DischargeLampsConfig.DEFAULT_CONTROL_FONT, string, color, PhotoelectricPlateGraphic.this.getWidth() / 2 - DischargeLampsConfig.DEFAULT_CONTROL_FONT.getSize() / 2, (int)(d * (double)(i + 1)));
                PhotoelectricPlateGraphic.this.chargeIndicatorGraphics.add(phetTextGraphic);
                PhotoelectricPlateGraphic.this.addGraphic(phetTextGraphic);
            }
            PhotoelectricPlateGraphic.this.setBoundsDirty();
            PhotoelectricPlateGraphic.this.repaint();
        }
    }
}

