/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.photoelectric.view;

import edu.colorado.phet.common.charts.GridLineSet;
import edu.colorado.phet.common.charts.LinePlot;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.charts.ScatterPlot;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.photoelectric.PhotoelectricConfig;
import edu.colorado.phet.photoelectric.model.PhotoelectricModel;
import edu.colorado.phet.photoelectric.view.PhotoelectricGraph;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.RenderingHints;

public class CurrentVsVoltageGraph
extends PhotoelectricGraph {
    private static Range2D range = new Range2D(PhotoelectricModel.MIN_VOLTAGE, 0.0, PhotoelectricModel.MAX_VOLTAGE, PhotoelectricModel.MAX_CURRENT);
    private static Dimension chartSize = PhotoelectricConfig.CHART_SIZE;
    private double lastVoltageRecorded;

    public CurrentVsVoltageGraph(Component component, final PhotoelectricModel photoelectricModel) {
        super(component, range, chartSize, 2.0, 2.0, PhotoelectricModel.MAX_CURRENT / 6.0, PhotoelectricModel.MAX_CURRENT / 6.0);
        GridLineSet gridLineSet = this.getHorizonalGridlines();
        gridLineSet.setMajorGridlinesColor(new Color(200, 200, 200));
        GridLineSet gridLineSet2 = this.getVerticalGridlines();
        gridLineSet2.setMajorGridlinesColor(new Color(200, 200, 200));
        this.getVerticalTicks().setMajorTickLabelsVisible(false);
        this.getVerticalTicks().setMinorTickLabelsVisible(false);
        this.getYAxis().setMajorTickLabelsVisible(false);
        Color color = Color.red;
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 80);
        LinePlot linePlot = new LinePlot(this.getComponent(), this, this.getLineDataSet(), new BasicStroke(3.0f), color2);
        linePlot.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.addDataSetGraphic(linePlot, 1.0E15);
        ScatterPlot scatterPlot = new ScatterPlot(this.getComponent(), this, this.getDotDataSet(), color, 5);
        this.addDataSetGraphic(scatterPlot, 1.0E15);
        photoelectricModel.addChangeListener(new PhotoelectricModel.ChangeListenerAdapter(){

            public void currentChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsVoltageGraph.this.setDotDataPoint(photoelectricModel.getVoltage(), photoelectricModel.getCurrent());
            }

            public void voltageChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsVoltageGraph.this.setDotDataPoint(photoelectricModel.getVoltage(), photoelectricModel.getCurrent());
                CurrentVsVoltageGraph.this.addLineDataPoint(photoelectricModel.getVoltage(), photoelectricModel.getCurrent(), photoelectricModel);
            }

            public void wavelengthChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsVoltageGraph.this.clearLinePlot();
                CurrentVsVoltageGraph.this.setDotDataPoint(photoelectricModel.getVoltage(), photoelectricModel.getCurrent());
            }

            public void beamIntensityChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsVoltageGraph.this.clearLinePlot();
            }

            public void targetMaterialChanged(PhotoelectricModel.ChangeEvent changeEvent) {
                CurrentVsVoltageGraph.this.clearLinePlot();
            }
        });
    }

    private void addLineDataPoint(double d, double d2, PhotoelectricModel photoelectricModel) {
        double d3 = 0.1 * (double)MathUtil.getSign(d - this.lastVoltageRecorded);
        double d4 = this.lastVoltageRecorded + d3;
        while (Math.abs(d4 - d) > Math.abs(d3)) {
            this.getLineDataSet().addPoint(d4, photoelectricModel.getCurrentForVoltage(d4));
            d4 += d3;
        }
        this.getLineDataSet().addPoint(d, d2);
        this.lastVoltageRecorded = d;
    }
}

