/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lasers.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.piccolophet.nodes.photon.PhotonImageCache;
import edu.colorado.phet.common.quantum.model.Photon;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class PhotonGraphic
extends PhetImageGraphic
implements SimpleObserver,
Photon.LeftSystemEventListener,
Photon.VelocityChangedListener {
    private static final PhotonImageCache CACHE = new PhotonImageCache();
    private double theta;
    private Photon photon;
    private Color color;
    private double baseImageHeight;
    private double baseImageWidth;
    private double xOffset;
    private double yOffset;
    public static final int s_imgHeight = (int)Photon.RADIUS;
    private static ArrayList s_inactiveInstances = new ArrayList();
    private static ArrayList s_instances = new ArrayList();
    private static HashMap s_colorToImage = new HashMap();
    static String s_imageName = "images/photon-comet.png";
    static BufferedImage s_particleImage;
    static BufferedImage s_IRphotonGraphic;
    private static int PHOTON_SIZE;
    private static boolean COMET_GRAPHIC;

    public static boolean isCometGraphic() {
        return COMET_GRAPHIC;
    }

    public static void setCometGraphic(boolean bl) {
        if (COMET_GRAPHIC != bl) {
            COMET_GRAPHIC = bl;
            s_colorToImage.clear();
        }
    }

    public static void setAllVisible(boolean bl, double d) {
        Color color = VisibleColor.wavelengthToColor(d);
        for (int i = 0; i < s_instances.size(); ++i) {
            PhotonGraphic photonGraphic = (PhotonGraphic)s_instances.get(i);
            if (!photonGraphic.color.equals(color)) continue;
            photonGraphic.setVisible(bl);
        }
    }

    public static PhotonGraphic getInstance(Component component, Photon photon) {
        PhotonGraphic photonGraphic;
        if (s_inactiveInstances.size() > 0) {
            int n = s_inactiveInstances.size() - 1;
            photonGraphic = (PhotonGraphic)s_inactiveInstances.get(n);
            s_inactiveInstances.remove(n);
            photonGraphic.setState(component, photon);
        } else {
            photonGraphic = new PhotonGraphic(component, photon);
        }
        return photonGraphic;
    }

    private PhotonGraphic(Component component, Photon photon) {
        super(component, PhotonGraphic.createImage(photon.getWavelength()));
        this.setState(component, photon);
        photon.addLeftSystemListener(this);
        this.updateImage();
        s_instances.add(this);
    }

    private void setState(Component component, Photon photon) {
        this.setComponent(component);
        this.photon = photon;
        this.color = VisibleColor.wavelengthToColor(photon.getWavelength());
        photon.addObserver(this);
        photon.addVelocityChangedListener(this);
        this.updateImage();
        this.computeOffsets(photon.getVelocity().getAngle());
        this.setLocation((int)(photon.getPosition().getX() - this.xOffset), (int)(photon.getPosition().getY() - this.yOffset));
    }

    private void updateImage() {
        BufferedImage bufferedImage;
        Double d = new Double(this.photon.getWavelength());
        if (this.photon.getWavelength() > 780.0) {
            bufferedImage = COMET_GRAPHIC ? s_IRphotonGraphic : PhotonGraphic.createImage(781.0);
        } else {
            bufferedImage = (BufferedImage)s_colorToImage.get(d);
            if (bufferedImage == null) {
                bufferedImage = PhotonGraphic.createImage(this.photon.getWavelength());
                s_colorToImage.put(d, bufferedImage);
            }
        }
        this.baseImageHeight = bufferedImage.getHeight();
        this.baseImageWidth = bufferedImage.getWidth();
        this.theta = this.photon.getVelocity().getAngle();
        this.setImage(BufferedImageUtils.getRotatedImage(bufferedImage, this.theta));
    }

    private static BufferedImage createCometImage(double d) {
        MakeDuotoneImageOp makeDuotoneImageOp = new MakeDuotoneImageOp(VisibleColor.wavelengthToColor(d));
        BufferedImage bufferedImage = new BufferedImage(s_particleImage.getWidth(), s_particleImage.getHeight(), 3);
        makeDuotoneImageOp.filter(s_particleImage, bufferedImage);
        return bufferedImage;
    }

    private static BufferedImage createImage(double d) {
        return COMET_GRAPHIC ? PhotonGraphic.createCometImage(d) : PhotonGraphic.createTwinkleImage(d);
    }

    private static BufferedImage createTwinkleImage(double d) {
        return BufferedImageUtils.toBufferedImage(CACHE.getImage(d, PHOTON_SIZE));
    }

    public void update() {
        this.setLocation((int)(this.photon.getPosition().getX() - this.xOffset), (int)(this.photon.getPosition().getY() - this.yOffset));
        this.setBoundsDirty();
        this.repaint();
    }

    public void velocityChanged(Photon.VelocityChangedEvent velocityChangedEvent) {
        this.updateImage();
        this.computeOffsets(this.photon.getVelocity().getAngle());
        this.setLocation((int)(this.photon.getPosition().getX() - this.xOffset), (int)(this.photon.getPosition().getY() - this.yOffset));
    }

    private void computeOffsets(double d) {
        this.theta = d = (d % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
        this.xOffset = 0.0;
        this.yOffset = 0.0;
        double d2 = 0.0;
        double d3 = this.baseImageWidth;
        double d4 = this.baseImageHeight;
        if (d >= 0.0 && d <= 1.5707963267948966) {
            this.xOffset = d3 * Math.cos(d) + d4 / 2.0 * Math.sin(d);
            this.yOffset = d3 * Math.sin(d) + d4 / 2.0 * Math.cos(d);
        }
        if (d > 1.5707963267948966 && d <= Math.PI) {
            d2 = d - 1.5707963267948966;
            this.xOffset = d4 / 2.0 * Math.cos(d2);
            this.yOffset = d3 * Math.cos(d2) + d4 / 2.0 * Math.sin(d2);
        }
        if (d > Math.PI && d <= 4.71238898038469) {
            d2 = d - Math.PI;
            this.xOffset = d4 / 2.0 * Math.sin(d2);
            this.yOffset = d4 / 2.0 * Math.cos(d2);
        }
        if (d > 4.71238898038469 && d <= Math.PI * 2) {
            d2 = Math.PI * 2 - d;
            this.xOffset = d3 * Math.cos(d2) + d4 / 2.0 * Math.sin(d2);
            this.yOffset = d4 / 2.0 * Math.cos(d2);
        }
    }

    public void leftSystemEventOccurred(Photon.LeftSystemEvent leftSystemEvent) {
        s_instances.remove(this);
        this.photon = null;
    }

    public static void setPhotonSize(int n) {
        if (PHOTON_SIZE != n) {
            PHOTON_SIZE = n;
            s_colorToImage.clear();
        }
    }

    public static int getPhotonSize() {
        return PHOTON_SIZE;
    }

    static {
        PHOTON_SIZE = 18;
        COMET_GRAPHIC = false;
        try {
            s_particleImage = ImageLoader.loadBufferedImage(s_imageName);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        double d = (double)s_imgHeight / (double)s_particleImage.getHeight();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        s_particleImage = affineTransformOp.filter(s_particleImage, null);
        int n = 180;
        s_IRphotonGraphic = new BufferedImage(s_particleImage.getWidth(), s_particleImage.getHeight(), 3);
        ColorModel colorModel = s_particleImage.getColorModel();
        for (int i = 0; i < s_particleImage.getWidth(); ++i) {
            for (int j = 0; j < s_particleImage.getHeight(); ++j) {
                int n2 = s_particleImage.getRGB(i, j);
                int n3 = colorModel.getAlpha(n2);
                int n4 = colorModel.getRed(n2);
                int n5 = colorModel.getGreen(n2);
                int n6 = colorModel.getBlue(n2);
                if (n3 > 0) {
                    n3 = n4 + n5 + n6 > n ? 0 : 255;
                }
                int n7 = n3 * 0x1000000;
                s_IRphotonGraphic.setRGB(i, j, n7);
            }
        }
    }
}

